/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.common.PlayerHelper;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class BlockTank
extends BlockEnumSmeltery<TankType> {
    public static final PropertyEnum<TankType> TYPE = PropertyEnum.func_177709_a((String)"type", TankType.class);
    public static final PropertyBool KNOB = PropertyBool.func_177716_a((String)"has_knob");

    public BlockTank() {
        super(Material.field_151576_e, TYPE, TankType.class);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabSmeltery);
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(field_149777_j);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTank();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE, KNOB});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean hasKnob = state.func_177229_b(TYPE) == TankType.TANK && worldIn.func_175623_d(pos.func_177984_a());
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(hasKnob));
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = super.func_176203_a(meta);
        if (meta == TankType.TANK.getMeta()) {
            state = state.func_177226_a((IProperty)KNOB, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)te;
        FluidTankInfo[] info = tank.getTankInfo(side);
        FluidStack inTank = null;
        if (info.length > 0) {
            inTank = info[0].fluid;
        }
        side = side.func_176734_d();
        ItemStack stack = playerIn.func_70694_bm();
        ItemStack result = null;
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) {
            FluidStack liquid = tank.drain(side, FluidContainerRegistry.getContainerCapacity((FluidStack)inTank, (ItemStack)stack), false);
            if (liquid != null && liquid.amount > 0) {
                tank.drain(side, FluidContainerRegistry.getContainerCapacity((FluidStack)liquid, (ItemStack)stack), true);
                result = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)stack);
            }
        } else if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (tank.canFill(side, liquid.getFluid())) {
                int amount = tank.fill(side, liquid, false);
                if (amount == liquid.amount) {
                    tank.fill(side, liquid, true);
                    result = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
                }
            } else {
                return true;
            }
        }
        if (result != null) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.field_71071_by.func_70298_a(playerIn.field_71071_by.field_70461_c, 1);
                PlayerHelper.spawnItemAtPlayer(playerIn, result);
            }
            return true;
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileTank)) {
            return 0;
        }
        TileTank tank = (TileTank)te;
        return tank.getBrightness();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public static enum TankType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TANK,
        GAUGE,
        WINDOW;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString();
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

