/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.client.SmelteryRenderer;
import slimeknights.tconstruct.smeltery.client.module.GuiSmelterySideinventory;
import slimeknights.tconstruct.smeltery.inventory.ContainerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;

public class GuiSmeltery
extends GuiMultiModule {
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/smeltery.png");
    protected GuiElement scala = new GuiElement(176, 76, 52, 52, 256, 256);
    protected final GuiSmelterySideinventory sideinventory;
    protected final TileSmeltery smeltery;
    private TileSmeltery.FuelInfo fuelInfo;

    public GuiSmeltery(ContainerSmeltery container, TileSmeltery smeltery) {
        super((ContainerMultiModule)container);
        this.smeltery = smeltery;
        this.sideinventory = new GuiSmelterySideinventory(this, container.getSubContainer(ContainerSideInventory.class), smeltery, smeltery.func_70302_i_(), container.calcColumns());
        this.addModule(this.sideinventory);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.scala.draw(8, 16);
        if (8 <= (mouseX -= this.cornerX) && mouseX < 60 && 16 <= (mouseY -= this.cornerY) && mouseY < 68) {
            FluidStack hovered = this.getFluidHovered(68 - mouseY - 1);
            ArrayList text = Lists.newArrayList();
            if (hovered == null) {
                int usedCap = this.smeltery.getTank().getUsedCapacity();
                int maxCap = this.smeltery.getTank().getMaxCapacity();
                text.add(EnumChatFormatting.WHITE + Util.translate("gui.smeltery.capacity", new Object[0]));
                text.add(EnumChatFormatting.GRAY.toString() + maxCap + Util.translate("gui.smeltery.liquid.millibucket", new Object[0]));
                text.add(Util.translateFormatted("gui.smeltery.capacity_available", new Object[0]));
                text.add(EnumChatFormatting.GRAY.toString() + (maxCap - usedCap) + Util.translate("gui.smeltery.liquid.millibucket", new Object[0]));
            } else {
                text.add(EnumChatFormatting.WHITE + hovered.getLocalizedName());
                this.liquidToString(hovered, text);
            }
            this.func_146283_a(text, mouseX, mouseY);
        } else if (71 <= mouseX && mouseX < 83 && 16 <= mouseY && mouseY < 68) {
            ArrayList text = Lists.newArrayList();
            FluidStack fuel = this.fuelInfo.fluid;
            text.add(EnumChatFormatting.WHITE + Util.translate("gui.smeltery.fuel", new Object[0]));
            if (fuel != null) {
                text.add(fuel.getLocalizedName());
                this.liquidToString(fuel, text);
            } else {
                text.add(Util.translate("gui.smeltery.fuel.empty", new Object[0]));
            }
            text.add(Util.translateFormatted("gui.smeltery.fuel.heat", this.fuelInfo.heat));
            this.func_146283_a(text, mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(BACKGROUND);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        SmelteryTank liquids = this.smeltery.getTank();
        if (liquids.getUsedCapacity() > 0) {
            int capacity = Math.max(liquids.getUsedCapacity(), liquids.getMaxCapacity());
            int[] heights = this.calcLiquidHeights(liquids.getFluids(), capacity);
            int x = 8 + this.cornerX;
            int y = 16 + this.scala.h + this.cornerY;
            int w = this.scala.w;
            Tessellator tessellator = Tessellator.func_178181_a();
            WorldRenderer worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            for (int i = 0; i < heights.length; ++i) {
                int h = heights[i];
                FluidStack liquid = liquids.getFluids().get(i);
                TextureAtlasSprite fluidSprite = this.field_146297_k.func_147117_R().func_110572_b(liquid.getFluid().getStill().toString());
                RenderUtil.putTiledTextureQuads(worldrenderer, x, y - h, w, h, this.field_73735_i, fluidSprite);
                y -= h;
            }
            tessellator.func_78381_a();
        }
        this.fuelInfo = this.smeltery.getFuelDisplay();
        if (this.fuelInfo.fluid != null && this.fuelInfo.fluid.amount > 0) {
            int x = 71 + this.cornerX;
            int y = 16 + this.cornerY + 52;
            int w = 12;
            int h = (int)(52.0f * (float)this.fuelInfo.fluid.amount / (float)this.fuelInfo.maxCap);
            TextureAtlasSprite fluidSprite = this.field_146297_k.func_147117_R().func_110572_b(this.fuelInfo.fluid.getFluid().getStill().toString());
            RenderUtil.renderTiledTextureAtlas(x, y - h, w, h, this.field_73735_i, fluidSprite);
        }
    }

    protected FluidStack getFluidHovered(int y) {
        SmelteryTank tank = this.smeltery.getTank();
        int[] heights = this.calcLiquidHeights(tank.getFluids(), tank.getMaxCapacity());
        for (int i = 0; i < heights.length; ++i) {
            if (y < heights[i]) {
                return tank.getFluids().get(i);
            }
            y -= heights[i];
        }
        return null;
    }

    protected int[] calcLiquidHeights(List<FluidStack> liquids, int capacity) {
        return SmelteryRenderer.calcLiquidHeights(liquids, capacity, this.scala.h, 3);
    }

    public void liquidToString(FluidStack fluid, List<String> text) {
        this.liquidToString(TinkerRegistryClient.getFluidDisplayType(fluid.getFluid()), fluid.amount, text);
    }

    public void liquidToString(TinkerRegistryClient.FluidDisplayType type, int amount, List<String> text) {
        if (Util.isShiftKeyDown()) {
            type = TinkerRegistryClient.FluidDisplayType.BUCKETS;
        }
        if (type == TinkerRegistryClient.FluidDisplayType.INGOTS) {
            amount = this.calcLiquidText(amount, 1296, Util.translate("gui.smeltery.liquid.block", new Object[0]), text);
            amount = this.calcLiquidText(amount, 144, Util.translate("gui.smeltery.liquid.ingot", new Object[0]), text);
            amount = this.calcLiquidText(amount, 16, Util.translate("gui.smeltery.liquid.nugget", new Object[0]), text);
        }
        if (type == TinkerRegistryClient.FluidDisplayType.SEARED) {
            amount = this.calcLiquidText(amount, 576, Util.translate("gui.smeltery.liquid.block", new Object[0]), text);
        }
        if (type == TinkerRegistryClient.FluidDisplayType.GLASS) {
            amount = this.calcLiquidText(amount, 1000, Util.translate("gui.smeltery.liquid.block", new Object[0]), text);
        } else if (type == TinkerRegistryClient.FluidDisplayType.BLOCKS) {
            amount = this.calcLiquidText(amount, 1296, Util.translate("gui.smeltery.liquid.block", new Object[0]), text);
        } else if (type == TinkerRegistryClient.FluidDisplayType.GEMS) {
            amount = this.calcLiquidText(amount, 640, Util.translate("gui.smeltery.liquid.gem", new Object[0]), text);
        } else {
            amount = this.calcLiquidText(amount, 1000000, Util.translate("gui.smeltery.liquid.kilobucket", new Object[0]), text);
            amount = this.calcLiquidText(amount, 1000, Util.translate("gui.smeltery.liquid.bucket", new Object[0]), text);
        }
        this.calcLiquidText(amount, 1, Util.translate("gui.smeltery.liquid.millibucket", new Object[0]), text);
    }

    private int calcLiquidText(int amount, int divider, String unit, List<String> text) {
        int full = amount / divider;
        if (full > 0) {
            text.add(String.format("%d %s%s", full, EnumChatFormatting.GRAY, unit));
        }
        return amount % divider;
    }
}

