/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.mantle.multiblock.IMasterLogic;
import slimeknights.mantle.multiblock.IServantLogic;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.SmelteryDamageSource;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryController;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.events.TinkerSmelteryEvent;
import slimeknights.tconstruct.smeltery.inventory.ContainerSmeltery;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockDetection;
import slimeknights.tconstruct.smeltery.multiblock.MultiblockSmeltery;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidUpdatePacket;
import slimeknights.tconstruct.smeltery.network.SmelteryFuelUpdatePacket;
import slimeknights.tconstruct.smeltery.network.SmelteryInventoryUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.TileHeatingStructure;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class TileSmeltery
extends TileHeatingStructure
implements IMasterLogic,
ITickable,
IInventoryGui,
ISmelteryTankHandler {
    static final Logger log = Util.getLogger("Smeltery");
    protected static final int MAX_SIZE = 7;
    protected static final int CAPACITY_PER_BLOCK = 1152;
    public boolean active;
    public MultiblockDetection.MultiblockStructure info;
    public List<BlockPos> tanks;
    public BlockPos currentTank;
    public FluidStack currentFuel;
    public BlockPos minPos;
    public BlockPos maxPos;
    protected SmelteryTank liquids;
    protected MultiblockSmeltery multiblock = new MultiblockSmeltery(this);
    protected int tick;

    public TileSmeltery() {
        super("gui.smeltery.name", 0, 1);
        this.liquids = new SmelteryTank(this);
        this.tanks = Lists.newLinkedList();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isActive()) {
            if (this.tick == 0) {
                this.checkSmelteryStructure();
            }
        } else {
            if (this.tick == 0) {
                this.interactWithEntitiesInside();
            }
            this.heatItems();
            this.alloyAlloys();
            if (this.needsFuel) {
                this.consumeFuel();
            }
        }
        this.tick = (this.tick + 1) % 20;
    }

    @Override
    protected boolean onItemFinishedHeating(ItemStack stack, int slot) {
        MeltingRecipe recipe = TinkerRegistry.getMelting(stack);
        if (recipe == null) {
            return false;
        }
        TinkerSmelteryEvent.OnMelting event = TinkerSmelteryEvent.OnMelting.fireEvent(this, stack, recipe.output);
        int filled = this.liquids.fill(event.result, false);
        if (filled == event.result.amount) {
            this.liquids.fill(event.result, true);
            this.func_70299_a(slot, null);
            return true;
        }
        this.itemTemperatures[slot] = this.itemTempRequired[slot] * 2 + 1;
        return false;
    }

    protected void interactWithEntitiesInside() {
        AxisAlignedBB bb = this.info.getBoundingBox();
        List entities = this.field_145850_b.func_72872_a(Entity.class, bb);
        for (Entity entity : entities) {
            if (entity instanceof EntityItem) {
                if (TinkerRegistry.getMelting(((EntityItem)entity).func_92059_d()) == null) continue;
                continue;
            }
            FluidStack fluid = TinkerRegistry.getMeltingForEntity(entity);
            if (fluid == null && entity instanceof EntityLivingBase && entity.func_70089_S() && !entity.field_70128_L) {
                fluid = new FluidStack(FluidRegistry.WATER, 1);
            }
            if (fluid == null || !entity.func_70097_a((DamageSource)SmelteryDamageSource.instance, 1.0f)) continue;
            this.liquids.fill(fluid, true);
        }
    }

    protected void alloyAlloys() {
        for (AlloyRecipe recipe : TinkerRegistry.getAlloys()) {
            int matched = recipe.matches(this.liquids.getFluids());
            if (matched <= 0) continue;
            for (FluidStack liquid : recipe.getFluids()) {
                FluidStack toDrain = liquid.copy();
                FluidStack drained = this.liquids.drain(toDrain, true);
                if (drained.isFluidEqual(toDrain) && drained.amount == toDrain.amount) continue;
                log.error("Smeltery alloy creation drained incorrect amount: was %s:%d, should be %s:%d", new Object[]{drained.getUnlocalizedName(), drained.amount, toDrain.getUnlocalizedName(), toDrain.amount});
            }
            FluidStack toFill = recipe.getResult().copy();
            int filled = this.liquids.fill(toFill, true);
            if (filled == recipe.getResult().amount) continue;
            log.error("Smeltery alloy creation filled incorrect amount: was %d, should be %d (%s)", new Object[]{filled, recipe.getResult().amount * matched, recipe.getResult().getUnlocalizedName()});
        }
    }

    @Override
    protected void consumeFuel() {
        IFluidTank tank;
        FluidStack liquid;
        if (this.hasFuel()) {
            return;
        }
        this.searchForFuel();
        if (this.currentTank != null && (liquid = (tank = this.getTankAt(this.currentTank)).getFluid()) != null) {
            FluidStack in = liquid.copy();
            int bonusFuel = TinkerRegistry.consumeSmelteryFuel(in);
            int amount = liquid.amount - in.amount;
            FluidStack drained = tank.drain(amount, false);
            if (drained.amount == amount) {
                tank.drain(amount, true);
                this.currentFuel = drained.copy();
                this.addFuel(bonusFuel, drained.getFluid().getTemperature(drained));
                if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                    TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFuelUpdatePacket(this.field_174879_c, this.currentTank, this.temperature, this.currentFuel));
                }
            }
        }
    }

    private void searchForFuel() {
        if (this.currentTank != null && this.hasFuel(this.currentTank, this.currentFuel)) {
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasFuel(pos, this.currentFuel)) continue;
            this.currentTank = pos;
            return;
        }
        for (BlockPos pos : this.tanks) {
            if (!this.hasFuel(pos, null)) continue;
            this.currentTank = pos;
            return;
        }
        this.currentTank = null;
    }

    private boolean hasFuel(BlockPos pos, FluidStack preference) {
        IFluidTank tank = this.getTankAt(pos);
        if (tank != null && tank.getFluidAmount() > 0 && TinkerRegistry.isSmelteryFuel(tank.getFluid())) {
            if (preference != null && tank.getFluid().isFluidEqual(preference)) {
                return true;
            }
            if (preference == null) {
                return true;
            }
        }
        return false;
    }

    private IFluidTank getTankAt(BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof TileTank) {
            return ((TileTank)te).getInternalTank();
        }
        return null;
    }

    public void notifyChange(IServantLogic servant, BlockPos pos) {
        this.checkSmelteryStructure();
    }

    public void checkSmelteryStructure() {
        boolean wasActive = this.isActive();
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockSmelteryController)) {
            this.active = false;
        } else {
            EnumFacing in = ((EnumFacing)state.func_177229_b((IProperty)BlockSmelteryController.FACING)).func_176734_d();
            MultiblockDetection.MultiblockStructure structure = this.multiblock.detectMultiblock(this.field_145850_b, this.func_174877_v().func_177972_a(in), 7);
            if (structure == null) {
                this.active = false;
                this.updateSmelteryInfo(new MultiblockDetection.MultiblockStructure(0, 0, 0, Lists.newLinkedList()));
            } else {
                this.active = true;
                MultiblockDetection.assignMultiBlock(this.field_145850_b, this.func_174877_v(), structure.blocks);
                this.updateSmelteryInfo(structure);
                if (wasActive) {
                    this.field_145850_b.func_175689_h(this.field_174879_c);
                }
            }
        }
        if (wasActive != this.isActive()) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
            this.func_70296_d();
        }
    }

    protected void updateSmelteryInfo(MultiblockDetection.MultiblockStructure structure) {
        this.info = structure;
        if (this.info != null) {
            this.minPos = this.info.minPos.func_177982_a(1, 1, 1);
            this.maxPos = this.info.maxPos.func_177982_a(-1, 0, -1);
        } else {
            this.minPos = this.maxPos = this.field_174879_c;
        }
        this.tanks.clear();
        for (BlockPos pos : structure.blocks) {
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() != TinkerSmeltery.searedTank) continue;
            this.tanks.add(pos);
        }
        int inventorySize = structure.xd * structure.yd * structure.zd;
        if (this.func_70302_i_() > inventorySize) {
            for (int i = inventorySize; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) == null) continue;
                this.dropItem(this.func_70301_a(i));
            }
        }
        this.liquids.setCapacity(inventorySize * 1152);
        this.resize(inventorySize);
    }

    private void dropItem(ItemStack stack) {
        EnumFacing direction = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockSmelteryController.FACING);
        BlockPos pos = this.func_174877_v().func_177972_a(direction);
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public SmelteryTank getTank() {
        return this.liquids;
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerSmeltery(inventoryplayer, this);
    }

    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiSmeltery((ContainerSmeltery)this.createContainer(inventoryplayer, world, pos), this);
    }

    public float getMeltingProgress(int index) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return -1.0f;
        }
        if (this.itemTempRequired[index] > this.temperature) {
            return -1.0f;
        }
        return (float)this.itemTemperatures[index] / (float)this.itemTempRequired[index];
    }

    @SideOnly(value=Side.CLIENT)
    public FuelInfo getFuelDisplay() {
        FuelInfo info = new FuelInfo();
        if (this.hasFuel()) {
            info.fluid = this.currentFuel.copy();
            info.fluid.amount = 0;
            info.heat = this.temperature;
            info.maxCap = this.currentFuel.amount;
        } else if (this.currentTank != null && this.hasFuel(this.currentTank, this.currentFuel)) {
            IFluidTank tank = this.getTankAt(this.currentTank);
            info.fluid = tank.getFluid().copy();
            info.heat = this.temperature;
            info.maxCap = tank.getCapacity();
        }
        for (BlockPos pos : this.tanks) {
            IFluidTank tank;
            if (pos == this.currentTank || (tank = this.getTankAt(pos)) == null || tank.getFluidAmount() <= 0) continue;
            if (info.fluid == null) {
                info.fluid = tank.getFluid().copy();
                info.heat = info.fluid.getFluid().getTemperature(info.fluid);
                info.maxCap = tank.getCapacity();
                continue;
            }
            if (!tank.getFluid().isFluidEqual(info.fluid)) continue;
            info.fluid.amount += tank.getFluidAmount();
            info.maxCap += tank.getCapacity();
        }
        return info;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_178781_a((double)this.minPos.func_177958_n(), (double)this.minPos.func_177956_o(), (double)this.minPos.func_177952_p(), (double)(this.maxPos.func_177958_n() + 1), (double)(this.maxPos.func_177956_o() + 1), (double)(this.maxPos.func_177952_p() + 1));
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        if (this.field_145850_b != null && this.field_145850_b instanceof WorldServer && !this.field_145850_b.field_72995_K && !ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)this.func_70301_a(slot))) {
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new SmelteryInventoryUpdatePacket(itemstack, slot, this.field_174879_c));
        }
        super.func_70299_a(slot, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTemperatureFromPacket(int index, int heat) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return;
        }
        this.itemTemperatures[index] = heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidsFromPacket(List<FluidStack> fluids) {
        this.liquids.setFluids(fluids);
    }

    @Override
    public void onTankChanged(List<FluidStack> fluids, FluidStack changed) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TinkerNetwork.sendToAll((AbstractPacket)new SmelteryFluidUpdatePacket(this.field_174879_c, fluids));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.active = false;
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.liquids.writeToNBT(compound);
        compound.func_74757_a("active", this.active);
        compound.func_74782_a("currentTank", (NBTBase)TagUtil.writePos(this.currentTank));
        NBTTagList tankList = new NBTTagList();
        for (BlockPos pos : this.tanks) {
            tankList.func_74742_a((NBTBase)TagUtil.writePos(pos));
        }
        compound.func_74782_a("tanks", (NBTBase)tankList);
        NBTTagCompound fuelTag = new NBTTagCompound();
        if (this.currentFuel != null) {
            this.currentFuel.writeToNBT(fuelTag);
        }
        compound.func_74782_a("currentFuel", (NBTBase)fuelTag);
        compound.func_74782_a("minPos", (NBTBase)TagUtil.writePos(this.minPos));
        compound.func_74782_a("maxPos", (NBTBase)TagUtil.writePos(this.maxPos));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.liquids.readFromNBT(compound);
        this.active = compound.func_74767_n("active");
        NBTTagList tankList = compound.func_150295_c("tanks", 10);
        this.tanks.clear();
        for (int i = 0; i < tankList.func_74745_c(); ++i) {
            this.tanks.add(TagUtil.readPos(tankList.func_150305_b(i)));
        }
        NBTTagCompound fuelTag = compound.func_74775_l("currentFuel");
        this.currentFuel = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fuelTag);
        this.minPos = TagUtil.readPos(compound.func_74775_l("minPos"));
        this.maxPos = TagUtil.readPos(compound.func_74775_l("maxPos"));
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        boolean wasActive = this.active;
        this.func_145839_a(pkt.func_148857_g());
        if (this.isActive() != wasActive) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public static class FuelInfo {
        public int heat;
        public int maxCap;
        public FluidStack fluid;
    }
}

