/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class TileTank
extends TileSmelteryComponent
implements IFluidHandler {
    public static final int CAPACITY = 4000;
    public FluidTank tank = new FluidTank(4000);
    public float renderOffset;

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.renderOffset = resource.amount;
        }
        return amount;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.renderOffset = -maxDrain;
        }
        return amount;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.getFluidAmount() == 0 || this.tank.getFluid().getFluid() == fluid && this.tank.getFluidAmount() < this.tank.getCapacity();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    IFluidTank getInternalTank() {
        return this.tank;
    }

    public float getFluidAmountScaled() {
        return ((float)this.tank.getFluid().amount - this.renderOffset) / ((float)this.tank.getCapacity() * 1.01f);
    }

    public boolean containsFluid() {
        return this.tank.getFluid() != null;
    }

    public int getBrightness() {
        if (this.containsFluid()) {
            return this.tank.getFluid().getFluid().getLuminosity();
        }
        return 0;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.tank.readFromNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.tank.writeToNBT(tags);
    }

    public int comparatorStrength() {
        return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }
}

