/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.texture.ExtraUtilityTexture;
import slimeknights.tconstruct.library.client.texture.MetalColoredTexture;
import slimeknights.tconstruct.library.client.texture.MetalTextureTexture;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.modifiers.traits.TraitAlien;
import slimeknights.tconstruct.tools.modifiers.traits.TraitAquadynamic;
import slimeknights.tconstruct.tools.modifiers.traits.TraitAridiculous;
import slimeknights.tconstruct.tools.modifiers.traits.TraitCheap;
import slimeknights.tconstruct.tools.modifiers.traits.TraitCrude;
import slimeknights.tconstruct.tools.modifiers.traits.TraitDuritos;
import slimeknights.tconstruct.tools.modifiers.traits.TraitEcological;
import slimeknights.tconstruct.tools.modifiers.traits.TraitInsatiable;
import slimeknights.tconstruct.tools.modifiers.traits.TraitMagnetic;
import slimeknights.tconstruct.tools.modifiers.traits.TraitMomentum;
import slimeknights.tconstruct.tools.modifiers.traits.TraitPetramor;
import slimeknights.tconstruct.tools.modifiers.traits.TraitPrickly;
import slimeknights.tconstruct.tools.modifiers.traits.TraitSlimey;
import slimeknights.tconstruct.tools.modifiers.traits.TraitSplintering;
import slimeknights.tconstruct.tools.modifiers.traits.TraitSqueaky;
import slimeknights.tconstruct.tools.modifiers.traits.TraitStonebound;
import slimeknights.tconstruct.tools.modifiers.traits.TraitTasty;
import slimeknights.tconstruct.tools.modifiers.traits.TraitUnnatural;

@Pulse(id="TinkerMaterials", description="All the tool materials added by TConstruct", pulsesRequired="TinkerTools")
public final class TinkerMaterials {
    static final String PulseId = "TinkerMaterials";
    static final Logger log = Util.getLogger("TinkerMaterials");
    public static final List<Material> materials = Lists.newArrayList();
    private static final Map<Material, String> materialPrerequisite = Maps.newHashMap();
    public static final Material wood = TinkerMaterials.mat("wood", 9332251);
    public static final Material stone = TinkerMaterials.mat("stone", 0x999999);
    public static final Material flint = TinkerMaterials.mat("flint", 0x696969);
    public static final Material cactus = TinkerMaterials.mat("cactus", 41231);
    public static final Material bone = TinkerMaterials.mat("bone", 15591103);
    public static final Material obsidian = TinkerMaterials.mat("obsidian", 6298820);
    public static final Material prismarine = TinkerMaterials.mat("prismarine", 8314556);
    public static final Material endstone = TinkerMaterials.mat("endstone", 14735504);
    public static final Material paper = new Material("paper", 0xFFFFFF);
    public static final Material sponge = TinkerMaterials.mat("sponge", 13290574);
    public static final Material knightslime = TinkerMaterials.mat("knightslime", 14696414, "ingotKnightslime");
    public static final Material slime = TinkerMaterials.mat("slime", 8570995);
    public static final Material blueslime = TinkerMaterials.mat("blueslime", 7653575, "slimeballBlue");
    public static final Material iron = TinkerMaterials.mat("iron", 0xCACACA);
    public static final Material pigiron = TinkerMaterials.mat("pigiron", 16751812, "ingotPigiron");
    public static final Material copper = TinkerMaterials.mat("copper", 15572743, "ingotCopper");
    public static final Material bronze = TinkerMaterials.mat("bronze", 13805673, "ingotBronze");
    public static final Material netherrack = TinkerMaterials.mat("netherrack", 12078927);
    public static final Material ardite = TinkerMaterials.mat("ardite", 13713936, "ingotArdite");
    public static final Material cobalt = TinkerMaterials.mat("cobalt", 2654932, "ingotCobalt");
    public static final Material manyullyn = TinkerMaterials.mat("manyullyn", 0x882FF8, "ingotManyullyn");
    public static final Material xu;
    public static final AbstractTrait alien;
    public static final AbstractTrait aquadynamic;
    public static final AbstractTrait aridiculous;
    public static final AbstractTrait cheap;
    public static final AbstractTrait crude;
    public static final AbstractTrait duritos;
    public static final AbstractTrait ecological;
    public static final AbstractTrait insatiable;
    public static final AbstractTrait magnetic;
    public static final AbstractTrait momentum;
    public static final AbstractTrait petramor;
    public static final AbstractTrait prickly;
    public static final AbstractTrait slimeyGreen;
    public static final AbstractTrait slimeyBlue;
    public static final AbstractTrait splintering;
    public static final AbstractTrait squeaky;
    public static final AbstractTrait stonebound;
    public static final AbstractTrait tasty;
    public static final AbstractTrait unnatural;

    private static Material mat(String name, int color) {
        return TinkerMaterials.mat(name, color, null);
    }

    private static Material mat(String name, int color, String oredict) {
        Material mat = new Material(name, color);
        materials.add(mat);
        if (oredict != null) {
            materialPrerequisite.put(mat, oredict);
        }
        return mat;
    }

    private void registerMaterials() {
        for (Material material : materials) {
            if (materialPrerequisite.containsKey((Object)material)) {
                String oredict = materialPrerequisite.get((Object)material);
                boolean found = false;
                for (String ore : OreDictionary.getOreNames()) {
                    if (!ore.equals(oredict)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    log.debug("Material %s was not registered due to missing oredict entry: ", new Object[]{material.getIdentifier(), oredict});
                    continue;
                }
            }
            TinkerRegistry.addMaterial(material);
        }
    }

    @Subscribe
    public void registerRendering(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            TinkerMaterials.registerMaterialRendering();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerMaterialRendering() {
        wood.setRenderInfo(new MaterialRenderInfo.MultiColor(7231274, 7626552, 9332509));
        stone.setRenderInfo(0x696969);
        flint.setRenderInfo(0xFFFFFF).setTextureSuffix("contrast");
        cactus.setRenderInfo(27914);
        obsidian.setRenderInfo(new MaterialRenderInfo.MultiColor(7428252, 9396436, 9196511).setTextureSuffix("contrast"));
        prismarine.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/prismarine_bricks"));
        netherrack.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/netherrack"));
        endstone.setRenderInfo(new MaterialRenderInfo.InverseMultiColor(6054550, 3949174, 2173558));
        bone.setRenderInfo(15591103).setTextureSuffix("bone_base");
        paper.setRenderInfo(0xFFFFFF);
        sponge.setRenderInfo(new MaterialRenderInfo.BlockTexture("minecraft:blocks/sponge"));
        slime.setRenderInfo(8570995);
        blueslime.setRenderInfo(7653575);
        iron.setRenderInfo(new MaterialRenderInfo.Metal(0xCACACA, 0.0f, 0.3f, 0.0f));
        cobalt.setRenderInfo(new MaterialRenderInfo.Metal(1522549, 0.25f, 0.5f, -0.1f));
        ardite.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new MetalTextureTexture(Util.resource("items/materials/ardite_rust"), baseTexture, location, 16347671, 0.6f, 0.4f, 0.1f);
            }
        });
        manyullyn.setRenderInfo(new MaterialRenderInfo.Metal(11091445, 0.4f, 0.2f, -0.1f));
        pigiron.setRenderInfo(new MaterialRenderInfo.Metal(13859960, 0.1f, 0.1f, 0.0f));
        knightslime.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new MetalColoredTexture(baseTexture, location, 6839248, 0.0f, 0.5f, 0.3f);
            }
        });
        xu.setRenderInfo(new MaterialRenderInfo.AbstractMaterialRenderInfo(){

            @Override
            public TextureAtlasSprite getTexture(TextureAtlasSprite baseTexture, String location) {
                return new ExtraUtilityTexture(baseTexture, location);
            }
        });
    }

    @Subscribe
    public void setupMaterials(FMLInitializationEvent event) {
        this.registerMaterials();
        wood.setCraftable(true);
        wood.addItem("stickWood", 1, 72);
        wood.addItem("plankWood", 1, 144);
        wood.addItem("logWood", 1, 576);
        wood.setRepresentativeItem(new ItemStack(Items.field_151055_y));
        wood.addTrait(ecological);
        stone.setCraftable(true);
        stone.addItem("cobblestone", 1, 144);
        stone.addItem("stone", 1, 144);
        stone.setRepresentativeItem(new ItemStack(Blocks.field_150347_e));
        stone.addTrait(cheap);
        flint.setCraftable(true);
        flint.addItem(Items.field_151145_ak, 1, 144);
        flint.setRepresentativeItem(new ItemStack(Items.field_151145_ak));
        flint.addTrait(crude);
        cactus.setCraftable(true);
        cactus.addItem("blockCactus", 1, 144);
        cactus.setRepresentativeItem(new ItemStack((Block)Blocks.field_150434_aF));
        cactus.addTrait(prickly);
        obsidian.setFluid(FluidRegistry.WATER);
        obsidian.setCraftable(true);
        obsidian.setCastable(true);
        obsidian.addItem(Blocks.field_150343_Z, 144);
        obsidian.setRepresentativeItem(new ItemStack(Blocks.field_150343_Z));
        obsidian.addTrait(duritos);
        prismarine.setCraftable(true);
        prismarine.addItem(Items.field_179562_cC, 1, 36);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176331_b), 1, 144);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176333_M), 1, 324);
        prismarine.addItem(new ItemStack(Blocks.field_180397_cI, 1, BlockPrismarine.field_176334_N), 1, 288);
        prismarine.setRepresentativeItem(Blocks.field_180397_cI);
        prismarine.addTrait(aquadynamic);
        netherrack.setCraftable(true);
        netherrack.addItem(Blocks.field_150424_aL, 144);
        netherrack.setRepresentativeItem(Blocks.field_150424_aL);
        netherrack.addTrait(aridiculous);
        endstone.setCraftable(true);
        endstone.addItem(Blocks.field_150377_bs, 144);
        endstone.setRepresentativeItem(Blocks.field_150377_bs);
        endstone.addTrait(alien);
        bone.setCraftable(true);
        bone.addItem(Items.field_151103_aS, 1, 144);
        bone.setRepresentativeItem(Items.field_151103_aS);
        bone.addTrait(splintering);
        paper.setCraftable(true);
        paper.addItem(Items.field_151121_aF, 1, 36);
        paper.setRepresentativeItem(Items.field_151121_aF);
        sponge.setCraftable(true);
        sponge.addItem(Blocks.field_150360_v, 144);
        sponge.setRepresentativeItem(Blocks.field_150360_v);
        sponge.addTrait(squeaky);
        slime.setCraftable(true);
        this.safeAdd(slime, TinkerCommons.matSlimeCrystal, 144, true);
        slime.addTrait(slimeyGreen);
        blueslime.setCraftable(true);
        this.safeAdd(blueslime, TinkerCommons.matSlimeCrystalBlue, 144, true);
        blueslime.addTrait(slimeyBlue);
        knightslime.setCraftable(true);
        this.safeAdd(knightslime, TinkerCommons.ingotKnightSlime, 144, true);
        knightslime.addTrait(unnatural);
        iron.setFluid(FluidRegistry.WATER);
        iron.setCastable(true);
        iron.addItem("ingotIron", 1, 144);
        iron.setRepresentativeItem(Items.field_151042_j);
        iron.addTrait(magnetic);
        pigiron.setFluid(FluidRegistry.WATER);
        pigiron.setCastable(true);
        pigiron.addTrait(tasty);
        cobalt.setFluid(FluidRegistry.WATER);
        cobalt.setCastable(true);
        this.safeAdd(cobalt, TinkerCommons.ingotCobalt, 144, true);
        cobalt.addTrait(momentum);
        ardite.setFluid(FluidRegistry.WATER);
        ardite.setCastable(true);
        this.safeAdd(ardite, TinkerCommons.ingotArdite, 144, true);
        ardite.addTrait(petramor);
        manyullyn.setFluid(FluidRegistry.WATER);
        manyullyn.setCastable(true);
        this.safeAdd(manyullyn, TinkerCommons.ingotManyullyn, 144, true);
        manyullyn.addTrait(insatiable);
        this.registerToolMaterials();
    }

    private void safeAdd(Material material, ItemStack item, int value) {
        this.safeAdd(material, item, value, false);
    }

    private void safeAdd(Material material, ItemStack item, int value, boolean representative) {
        if (item != null) {
            material.addItem(item, 1, value);
            if (representative) {
                material.setRepresentativeItem(item);
            }
        }
    }

    public void registerToolMaterials() {
        TinkerRegistry.addMaterialStats(wood, (IMaterialStats)new ToolMaterialStats(73, 3.4f, 2.0f, 0.75f, 0.5f, 0));
        TinkerRegistry.addMaterialStats(stone, (IMaterialStats)new ToolMaterialStats(131, 3.8f, 2.1f, 0.05f, 0.18f, 1));
        TinkerRegistry.addMaterialStats(flint, (IMaterialStats)new ToolMaterialStats(235, 5.0f, 2.8f, 0.2f, 0.19f, 1));
        TinkerRegistry.addMaterialStats(cactus, (IMaterialStats)new ToolMaterialStats(329, 4.5f, 3.4f, 0.25f, 0.43f, 1));
        TinkerRegistry.addMaterialStats(bone, (IMaterialStats)new ToolMaterialStats(373, 5.09f, 2.5f, 0.81f, 0.56f, 1));
        TinkerRegistry.addMaterialStats(obsidian, (IMaterialStats)new ToolMaterialStats(89, 7.07f, 4.2f, 0.07f, 0.24f, 4));
        TinkerRegistry.addMaterialStats(prismarine, (IMaterialStats)new ToolMaterialStats(530, 5.5f, 5.5f, 0.18f, 0.84f, 1));
        TinkerRegistry.addMaterialStats(endstone, (IMaterialStats)new ToolMaterialStats(412, 3.23f, 3.23f, 0.33f, 0.33f, 3));
        TinkerRegistry.addMaterialStats(paper, (IMaterialStats)new ToolMaterialStats(42, 0.51f, 0.05f, 0.01f, 0.7f, 0));
        TinkerRegistry.addMaterialStats(sponge, (IMaterialStats)new ToolMaterialStats(650, 3.02f, 0.0f, 0.05f, 0.01f, 0));
        TinkerRegistry.addMaterialStats(slime, (IMaterialStats)new ToolMaterialStats(600, 4.24f, 1.8f, 0.3f, 1.0f, 0));
        TinkerRegistry.addMaterialStats(blueslime, (IMaterialStats)new ToolMaterialStats(780, 4.03f, 1.8f, 1.0f, 0.15f, 0));
        TinkerRegistry.addMaterialStats(knightslime, (IMaterialStats)new ToolMaterialStats(902, 3.81f, 5.1f, 0.76f, 0.46f, 3));
        TinkerRegistry.addMaterialStats(netherrack, (IMaterialStats)new ToolMaterialStats(322, 4.89f, 3.0f, 0.1f, 0.27f, 1));
        TinkerRegistry.addMaterialStats(cobalt, (IMaterialStats)new ToolMaterialStats(680, 10.0f, 4.1f, 0.4f, 0.6f, 4));
        TinkerRegistry.addMaterialStats(ardite, (IMaterialStats)new ToolMaterialStats(989, 2.42f, 3.6f, 0.64f, 0.78f, 4));
        TinkerRegistry.addMaterialStats(manyullyn, (IMaterialStats)new ToolMaterialStats(513, 7.02f, 8.72f, 0.3f, 0.7f, 4));
        TinkerRegistry.addMaterialStats(iron, (IMaterialStats)new ToolMaterialStats(275, 5.7f, 6.0f, 0.5f, 0.6f, 2));
        TinkerRegistry.addMaterialStats(pigiron, (IMaterialStats)new ToolMaterialStats(380, 6.2f, 4.5f, 0.66f, 0.73f, 3));
    }

    public void registerBowMaterials() {
    }

    public void registerProjectileMaterials() {
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        if (TinkerTools.shard == null) {
            return;
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            ItemStack shard = TinkerTools.shard.getItemstackWithMaterial(material);
            material.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(72, new ItemStack[]{shard}));
            if (material.getShard() == null) continue;
            material.setShard(shard);
        }
    }

    static {
        alien = new TraitAlien();
        aquadynamic = new TraitAquadynamic();
        aridiculous = new TraitAridiculous();
        cheap = new TraitCheap();
        crude = new TraitCrude();
        duritos = new TraitDuritos();
        ecological = new TraitEcological();
        insatiable = new TraitInsatiable();
        magnetic = new TraitMagnetic();
        momentum = new TraitMomentum();
        petramor = new TraitPetramor();
        prickly = new TraitPrickly();
        slimeyGreen = new TraitSlimey(EntitySlime.class);
        slimeyBlue = new TraitSlimey(EntitySlime.class);
        splintering = new TraitSplintering();
        squeaky = new TraitSqueaky();
        stonebound = new TraitStonebound();
        tasty = new TraitTasty();
        unnatural = new TraitUnnatural();
        xu = new Material("unstable", EnumChatFormatting.WHITE);
    }
}

