/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.shared.client.BakedTableModel;
import slimeknights.tconstruct.tools.ToolClientProxy;

@SideOnly(value=Side.CLIENT)
public class ToolClientEvents {
    public static Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
        }
    };
    private static final ResourceLocation MODEL_CraftingStation = Util.getResource("block/craftingstation");
    private static final ResourceLocation MODEL_StencilTable = Util.getResource("block/stenciltable");
    private static final ResourceLocation MODEL_PartBuilder = Util.getResource("block/partbuilder");
    private static final ResourceLocation MODEL_ToolStation = Util.getResource("block/toolstation");
    private static final ResourceLocation MODEL_ToolForge = Util.getResource("block/toolforge");
    private static final String LOCATION_ToolTable = Util.resource("tooltables");
    private static final String LOCATION_ToolForge = Util.resource("toolforge");
    public static final ModelResourceLocation locCraftingStation = new ModelResourceLocation(LOCATION_ToolTable, "type=craftingstation");
    public static final ModelResourceLocation locStencilTable = new ModelResourceLocation(LOCATION_ToolTable, "type=stenciltable");
    public static final ModelResourceLocation locPartBuilder = new ModelResourceLocation(LOCATION_ToolTable, "type=partbuilder");
    public static final ModelResourceLocation locToolStation = new ModelResourceLocation(LOCATION_ToolTable, "type=toolstation");
    public static final ModelResourceLocation locToolForge = new ModelResourceLocation(LOCATION_ToolForge, "normal");
    private static final ResourceLocation MODEL_BlankPattern = Util.getResource("item/pattern");
    public static final ResourceLocation locBlankPattern = Util.getResource("pattern");

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        ToolClientEvents.replacePatternModel(locBlankPattern, MODEL_BlankPattern, event, CustomTextureCreator.patternLocString);
        ToolClientEvents.replaceTableModel(locCraftingStation, MODEL_CraftingStation, event);
        ToolClientEvents.replaceTableModel(locStencilTable, MODEL_StencilTable, event);
        ToolClientEvents.replaceTableModel(locPartBuilder, MODEL_PartBuilder, event);
        ToolClientEvents.replaceTableModel(locToolStation, MODEL_ToolStation, event);
        ToolClientEvents.replaceTableModel(locToolForge, MODEL_ToolForge, event);
        event.modelRegistry.func_82595_a((Object)new ModelResourceLocation(LOCATION_ToolTable, "inventory"), event.modelRegistry.func_82594_a((Object)locToolStation));
        event.modelRegistry.func_82595_a((Object)new ModelResourceLocation(LOCATION_ToolForge, "inventory"), event.modelRegistry.func_82594_a((Object)locToolForge));
    }

    public static void replaceTableModel(ModelResourceLocation modelVariantLocation, ResourceLocation modelLocation, ModelBakeEvent event) {
        try {
            IModel model = event.modelLoader.getModel(modelLocation);
            if (model instanceof IRetexturableModel) {
                IRetexturableModel tableModel = (IRetexturableModel)model;
                IFlexibleBakedModel standard = (IFlexibleBakedModel)event.modelRegistry.func_82594_a((Object)modelVariantLocation);
                BakedTableModel finalModel = new BakedTableModel(standard, tableModel);
                event.modelRegistry.func_82595_a((Object)modelVariantLocation, (Object)finalModel);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void replacePatternModel(ResourceLocation locPattern, ResourceLocation modelLocation, ModelBakeEvent event, String baseString) {
        try {
            IModel model = event.modelLoader.getModel(modelLocation);
            if (model instanceof IRetexturableModel) {
                IRetexturableModel itemModel = (IRetexturableModel)model;
                for (IToolPart toolpart : TinkerRegistry.getToolParts()) {
                    if (!(toolpart instanceof Item)) continue;
                    ResourceLocation partLocation = ToolClientProxy.getItemLocation((Item)toolpart);
                    String suffix = partLocation.func_110623_a().toLowerCase(Locale.US);
                    String partPatternLocation = locPattern.toString() + "_" + suffix;
                    String partPatternTexture = baseString + suffix;
                    IModel partPatternModel = itemModel.retexture(ImmutableMap.of((Object)"layer0", (Object)partPatternTexture));
                    IFlexibleBakedModel baked = partPatternModel.bake(partPatternModel.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                    event.modelRegistry.func_82595_a((Object)new ModelResourceLocation(partPatternLocation, "inventory"), (Object)baked);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

