/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;

public class BlockToolTable
extends BlockTable
implements ITinkerStationBlock {
    public static final PropertyEnum<TableTypes> TABLES = PropertyEnum.func_177709_a((String)"type", TableTypes.class);

    public BlockToolTable() {
        super(Material.field_151575_d);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
        this.func_149672_a(field_149766_f);
        this.func_149752_b(5.0f);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (TableTypes.fromMeta(meta)) {
            case CraftingStation: {
                return new TileCraftingStation();
            }
            case StencilTable: {
                return new TileStencilTable();
            }
            case PartBuilder: {
                return new TilePartBuilder();
            }
            case ToolStation: {
                return new TileToolStation();
            }
            case PatternChest: {
                return new TilePatternChest();
            }
            case PartChest: {
                return new TilePartChest();
            }
        }
        return super.func_149915_a(worldIn, meta);
    }

    @Override
    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)TConstruct.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (player.field_71070_bA instanceof BaseContainer) {
            ((BaseContainer)player.field_71070_bA).syncOnOpen((EntityPlayerMP)player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, TableTypes.CraftingStation.meta));
        this.addBlocksFromOredict("plankWood", TableTypes.StencilTable.meta, list);
        list.add(new ItemStack((Block)this, 1, TableTypes.PatternChest.meta));
        this.addBlocksFromOredict("logWood", TableTypes.PartBuilder.meta, list);
        list.add(new ItemStack((Block)this, 1, TableTypes.PartChest.meta));
        list.add(new ItemStack((Block)this, 1, TableTypes.ToolStation.meta));
    }

    private void addBlocksFromOredict(String oredict, int meta, List<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            Block block = BlockToolTable.func_149634_a((Item)stack.func_77973_b());
            int blockMeta = stack.func_77952_i();
            if (blockMeta == Short.MAX_VALUE) {
                LinkedList subBlocks = Lists.newLinkedList();
                block.func_149666_a(stack.func_77973_b(), null, (List)subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add(BlockToolTable.createItemstack(this, meta, BlockToolTable.func_149634_a((Item)subBlock.func_77973_b()), subBlock.func_77952_i()));
                }
                continue;
            }
            list.add(BlockToolTable.createItemstack(this, meta, block, blockMeta));
        }
    }

    @Override
    protected boolean keepInventory(IBlockState state) {
        return Config.chestsKeepInventory && (state.func_177229_b(TABLES) == TableTypes.PatternChest || state.func_177229_b(TABLES) == TableTypes.PartChest);
    }

    @Override
    protected BlockState func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TABLES}, new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TABLES, (Comparable)((Object)TableTypes.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TableTypes)((Object)state.func_177229_b(BlockToolTable.TABLES))).meta;
    }

    @Override
    public int getGuiNumber(IBlockState state) {
        switch ((TableTypes)((Object)state.func_177229_b(TABLES))) {
            case StencilTable: {
                return 10;
            }
            case PatternChest: {
                return 15;
            }
            case PartChest: {
                return 16;
            }
            case PartBuilder: {
                return 20;
            }
            case ToolStation: {
                return 25;
            }
            case CraftingStation: {
                return 50;
            }
        }
        return 0;
    }

    public static enum TableTypes implements IStringSerializable
    {
        CraftingStation,
        StencilTable,
        PartBuilder,
        ToolStation,
        PatternChest,
        PartChest;

        public final int meta = this.ordinal();

        public static TableTypes fromMeta(int meta) {
            if (meta < 0 || meta >= TableTypes.values().length) {
                meta = 0;
            }
            return TableTypes.values()[meta];
        }

        public String func_176610_l() {
            return this.toString();
        }
    }
}

