/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class BattleAxe
extends AoeToolCore {
    public BattleAxe() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toughToolRod), new PartMaterialType.ToolPartType(TinkerTools.broadAxeHead), new PartMaterialType.ToolPartType(TinkerTools.broadAxeHead), new PartMaterialType.ToolPartType(TinkerTools.toughBinding));
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 2, 2, 1);
    }

    @Override
    public float damagePotential() {
        return 2.0f;
    }

    @Override
    public float damageCutoff() {
        return 30.0f;
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head1 = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats head2 = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(3).getStats("tool");
        ToolNBT data = new ToolNBT();
        data.harvestLevel = Math.max(head1.harvestLevel, head2.harvestLevel);
        data.durability = (head1.durability + head2.durability) / 2;
        data.handle(handle).extra(binding);
        data.durability = (int)((float)data.durability * (1.0f + 0.15f * (binding.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.1f * (handle.handleQuality * handle.miningspeed);
        data.speed *= 0.5f;
        data.attack = (head1.attack + head2.attack) * 3.0f / 2.0f;
        data.attack *= 1.0f + 0.1f * handle.handleQuality * binding.extraQuality;
        data.modifiers = 2;
        return data.get();
    }
}

