/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class BroadSword
extends ToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151569_G, (Object)Material.field_151582_l, (Object)Material.field_151589_v, (Object)Material.field_151572_C, (Object)Material.field_151584_j);

    public BroadSword() {
        this(new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.swordBlade), new PartMaterialType.ToolPartType(TinkerTools.wideGuard));
    }

    protected BroadSword(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.WEAPON);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.func_149688_o());
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public int attackSpeed() {
        return 1;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats guard = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(guard);
        data.durability = (int)((float)data.durability * (1.0f + 0.3f * (guard.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.05f * (handle.handleQuality * handle.miningspeed);
        data.attack += 3.0f;
        data.attack *= 1.0f + 0.15f * handle.handleQuality * guard.extraQuality;
        data.modifiers = 3;
        return data.get();
    }
}

