/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.Shovel;

public class Excavator
extends Shovel {
    public Excavator() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toughToolRod), new PartMaterialType.ToolPartType(TinkerTools.excavatorHead), new PartMaterialType.ToolPartType(TinkerTools.largePlate), new PartMaterialType.ToolPartType(TinkerTools.toughBinding));
    }

    @Override
    public float damagePotential() {
        return 0.3f;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 1);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats plate = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(3).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(plate, binding);
        data.durability = (int)((float)data.durability * (1.0f + 0.05f * (binding.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.3f * (handle.handleQuality * handle.miningspeed);
        data.attack = head.attack / 2.0f + plate.attack / 3.0f;
        data.attack *= 1.0f + 0.1f * handle.handleQuality * binding.extraQuality;
        data.modifiers = 3;
        return data.get();
    }
}

