/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.Pickaxe;

public class Hammer
extends Pickaxe {
    public Hammer() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toughToolRod), new PartMaterialType.ToolPartType(TinkerTools.hammerHead), new PartMaterialType.ToolPartType(TinkerTools.largePlate), new PartMaterialType.ToolPartType(TinkerTools.largePlate));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityPlayer player, EntityLivingBase entity, float damage) {
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            damage += (float)(3 + TConstruct.random.nextInt(4));
        }
        return super.dealDamage(stack, player, entity, damage);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 1);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats plate1 = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolMaterialStats plate2 = (ToolMaterialStats)materials.get(3).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(plate1, plate2);
        data.durability = (int)((float)data.durability * (1.0f + 0.1f * (head.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.2f * (handle.handleQuality * handle.miningspeed);
        data.speed *= 0.3f;
        data.attack = head.attack / 2.0f + (plate1.attack + plate2.attack) / 3.0f;
        data.attack *= 1.0f + 0.1f * handle.handleQuality * head.extraQuality;
        data.modifiers = 3;
        return data.get();
    }
}

