/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Hatchet
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151582_l, (Object)Material.field_151585_k, (Object)Material.field_151572_C, (Object)Material.field_151570_A);

    public Hatchet() {
        this(new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.axeHead), new PartMaterialType.ToolPartType(TinkerTools.binding));
    }

    protected Hatchet(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.addCategory(Category.WEAPON);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.func_149688_o()) || ItemAxe.field_150917_c.contains(block);
    }

    @Override
    public float damagePotential() {
        return 0.73f;
    }

    @Override
    public float knockback() {
        return 1.3f;
    }

    @Override
    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        if (state.func_177230_c().func_149688_o() == Material.field_151584_j) {
            return ToolHelper.calcDigSpeed(itemstack, state);
        }
        return super.getDigSpeed(itemstack, state);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public void afterBlockBreak(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase player, int damage, boolean wasEffective) {
        if (block.isLeaves((IBlockAccess)world, pos)) {
            damage = 0;
        }
        super.afterBlockBreak(stack, world, block, pos, player, damage, wasEffective);
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(binding);
        data.attack += 1.0f;
        data.durability = (int)((float)data.durability * (1.0f + 0.15f * (binding.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.1f * (handle.handleQuality * handle.miningspeed);
        data.attack *= 1.0f + 0.1f * handle.handleQuality * binding.extraQuality;
        data.modifiers = 3;
        return data.get();
    }
}

