/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.events.TinkerToolEvent;
import slimeknights.tconstruct.tools.item.Hatchet;

public class LumberAxe
extends Hatchet {
    public LumberAxe() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toughToolRod), new PartMaterialType.ToolPartType(TinkerTools.broadAxeHead), new PartMaterialType.ToolPartType(TinkerTools.largePlate), new PartMaterialType.ToolPartType(TinkerTools.toughBinding));
        this.categories.remove(Category.WEAPON);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (LumberAxe.detectTree(player.field_70170_p, pos)) {
            return LumberAxe.fellTree(itemstack, pos, player);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 3);
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats plate = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(3).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(binding, plate);
        data.durability = (int)((float)data.durability * (1.0f + 0.15f * (binding.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.1f * (handle.handleQuality * handle.miningspeed);
        data.speed *= 0.3f;
        data.attack = head.attack * 2.0f + plate.attack / 3.0f;
        data.attack *= 1.0f + 0.1f * handle.handleQuality * binding.extraQuality;
        data.modifiers = 3;
        return data.get();
    }

    public static boolean detectTree(World world, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.func_177956_o() <= pos.func_177956_o() || !LumberAxe.isLog(world, candidate)) continue;
            pos = candidate.func_177984_a();
            while (LumberAxe.isLog(world, pos)) {
                pos = pos.func_177984_a();
            }
            candidates.add(pos.func_177978_c());
            candidates.add(pos.func_177974_f());
            candidates.add(pos.func_177968_d());
            candidates.add(pos.func_177976_e());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.func_177982_a(o + x, o + y, o + z);
                    if (!world.func_180495_p(leaf).func_177230_c().isLeaves((IBlockAccess)world, leaf) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos);
    }

    public static boolean fellTree(ItemStack itemstack, BlockPos start, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(itemstack, player, 3, 3, 3, -1);
        int speed = Math.round((float)(event.width * event.height * event.depth) / 27.0f);
        if (event.distance > 0) {
            speed = event.distance + 1;
        }
        MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(itemstack, start, player, speed));
        return true;
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new THashSet();

        public TreeChopTask(ItemStack tool, BlockPos start, EntityPlayer player, int blocksPerTick) {
            this.world = player.func_130014_f_();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        @SubscribeEvent
        public void chopChop(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty() || ToolHelper.isBroken(this.tool)) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !LumberAxe.isLog(this.world, pos) || !ToolHelper.isToolEffective2(this.tool, this.world.func_180495_p(pos))) continue;
                for (EnumFacing facing : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}) {
                    BlockPos pos2 = pos.func_177972_a(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.func_177982_a(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                ToolHelper.breakExtraBlock(this.tool, this.world, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

