/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;

public class Mattock
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials_axe = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151570_A, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C);
    public static final ImmutableSet<Material> effective_materials_shovel = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151571_B);

    public Mattock() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.axeHead), new PartMaterialType.ToolPartType(TinkerTools.shovelHead));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("mattock", 0);
    }

    @Override
    public float getDigSpeed(ItemStack itemstack, IBlockState state) {
        Block block = state.func_177230_c();
        if (ToolHelper.canHarvest(itemstack, state)) {
            if (effective_materials_axe.contains((Object)block.func_149688_o()) || block.isToolEffective("axe", state)) {
                float strength = itemstack.func_77973_b().func_150893_a(itemstack, state.func_177230_c());
                float speed = TagUtil.getToolTag(itemstack).func_74760_g("MiningSpeedAxe");
                return strength * speed;
            }
            if (effective_materials_shovel.contains((Object)block.func_149688_o()) || block.isToolEffective("shovel", state)) {
                float strength = itemstack.func_77973_b().func_150893_a(itemstack, state.func_177230_c());
                float speed = TagUtil.getToolTag(itemstack).func_74760_g("MiningSpeedShovel");
                return strength * speed;
            }
        }
        return super.getDigSpeed(itemstack, state);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (toolClass == null) {
            return -1;
        }
        if (toolClass.equals("axe")) {
            return TagUtil.getToolTag(stack).func_74762_e("HarvestLevelAxe");
        }
        if (toolClass.equals("shovel")) {
            return TagUtil.getToolTag(stack).func_74762_e("HarvestLevelShovel");
        }
        return super.getHarvestLevel(stack, toolClass);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials_axe.contains((Object)block.func_149688_o()) || effective_materials_shovel.contains((Object)block.func_149688_o());
    }

    @Override
    public float damagePotential() {
        return 0.66f;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public boolean func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        boolean ret = Items.field_151012_L.func_180614_a(stack, playerIn, worldIn, pos, side, hitX, hitY, hitZ);
        for (BlockPos blockPos : this.getAOEBlocks(stack, worldIn, playerIn, pos)) {
            if (ToolHelper.isBroken(stack)) break;
            ret |= Items.field_151012_L.func_180614_a(stack, playerIn, worldIn, blockPos, side, hitX, hitY, hitZ);
        }
        return ret;
    }

    @Override
    public boolean isAoeHarvestTool() {
        return false;
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    @Override
    protected int calculateRepair(ItemStack tool, int materialValue, int index) {
        List<slimeknights.tconstruct.library.materials.Material> materials = TinkerUtil.getMaterialsFromTagList(TagUtil.getBaseMaterialsTagList(tool));
        ToolMaterialStats[] stats = new ToolMaterialStats[]{(ToolMaterialStats)materials.get(1).getStats("tool"), (ToolMaterialStats)materials.get(2).getStats("tool")};
        int total = stats[0].durability + stats[1].durability;
        float coeff = (float)stats[index - 1].durability / (float)total;
        return (int)Math.max(1.0f, (float)super.calculateRepair(tool, materialValue, index) * coeff);
    }

    @Override
    public String[] getInformation(ItemStack stack) {
        TooltipBuilder info = new TooltipBuilder(stack);
        MattockToolNBT data = new MattockToolNBT();
        data.read(TagUtil.getToolTag(stack));
        info.addDurability();
        info.addCustom("Axe:");
        info.addCustom(ToolMaterialStats.formatMiningSpeed(data.axeSpeed));
        info.addCustom(ToolMaterialStats.formatHarvestLevel(data.axeLevel));
        info.addCustom("Shovel:");
        info.addCustom(ToolMaterialStats.formatMiningSpeed(data.shovelSpeed));
        info.addCustom(ToolMaterialStats.formatHarvestLevel(data.shovelLevel));
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        return info.getTooltip();
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats axe = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats shovel = (ToolMaterialStats)materials.get(2).getStats("tool");
        MattockToolNBT data = new MattockToolNBT();
        data.durability = (axe.durability + shovel.durability) / 2;
        data.durability = (int)((float)data.durability * (1.0f + 0.05f * (axe.extraQuality * shovel.extraQuality)));
        data.speed = (axe.miningspeed + shovel.miningspeed) / 2.0f;
        data.speed *= 1.0f + 0.3f * (handle.handleQuality * handle.miningspeed);
        data.axeSpeed = axe.miningspeed * 0.8f + 0.2f * handle.handleQuality;
        data.shovelSpeed = shovel.miningspeed * 0.8f + 0.2f * handle.handleQuality;
        data.axeSpeed *= 0.7f;
        data.shovelSpeed *= 0.7f;
        data.axeLevel = axe.harvestLevel;
        data.shovelLevel = shovel.harvestLevel;
        data.harvestLevel = Math.round((float)(axe.harvestLevel + shovel.harvestLevel) / 2.0f);
        data.attack = 4.0f;
        data.attack += (axe.attack * 0.7f + shovel.attack * 0.3f) / 2.0f;
        data.modifiers = 3;
        return data.get();
    }

    public static class MattockToolNBT
    extends ToolNBT {
        private static final String TAG_Axe = "MiningSpeedAxe";
        private static final String TAG_Shovel = "MiningSpeedShovel";
        private static final String TAG_AxeLevel = "HarvestLevelAxe";
        private static final String TAG_ShovelLevel = "HarvestLevelShovel";
        public float axeSpeed;
        public float shovelSpeed;
        public int axeLevel;
        public int shovelLevel;

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.axeSpeed = tag.func_74760_g(TAG_Axe);
            this.shovelSpeed = tag.func_74760_g(TAG_Shovel);
            this.axeLevel = tag.func_74762_e(TAG_AxeLevel);
            this.shovelLevel = tag.func_74762_e(TAG_ShovelLevel);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74776_a(TAG_Axe, this.axeSpeed);
            tag.func_74776_a(TAG_Shovel, this.shovelSpeed);
            tag.func_74768_a(TAG_AxeLevel, this.axeLevel);
            tag.func_74768_a(TAG_ShovelLevel, this.shovelLevel);
        }
    }
}

