/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class Pickaxe
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151573_f, (Object)Material.field_151574_g, (Object)Material.field_151576_e, (Object)Material.field_151588_w, (Object)Material.field_151592_s, (Object)Material.field_151598_x, (Object[])new Material[]{Material.field_76233_E});

    public Pickaxe() {
        this(new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.pickHead), new PartMaterialType.ToolPartType(TinkerTools.binding));
    }

    public Pickaxe(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.func_149688_o()) || ItemPickaxe.field_150915_c.contains(block);
    }

    @Override
    public float damagePotential() {
        return 0.3f;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        data.handle(handle).extra(binding);
        data.durability = (int)((float)data.durability * (1.0f + 0.1f * (binding.extraQuality - 0.5f)));
        data.speed *= 1.0f + 0.2f * (handle.handleQuality * handle.miningspeed);
        data.attack *= 1.0f + 0.1f * handle.handleQuality * binding.extraQuality;
        data.modifiers = 3;
        return data.get();
    }
}

