/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ToolMaterialStats;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Scythe
extends ToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151569_G, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151577_b, (Object)Material.field_151582_l, (Object)Material.field_151572_C, (Object[])new Material[0]);

    public Scythe() {
        super(new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.toolRod), new PartMaterialType.ToolPartType(TinkerTools.toolRod));
    }

    @Override
    public float damagePotential() {
        return 1.3f;
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.func_149688_o());
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.isEffective(world.func_180495_p(pos).func_177230_c())) {
            for (BlockPos extraPos : ToolHelper.calcAOEBlocks(itemstack, player.field_70170_p, player, pos, 5, 5, 5, 4)) {
                if (!this.isEffective(world.func_180495_p(extraPos).func_177230_c())) continue;
                this.breakBlock(itemstack, extraPos, player);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    private boolean isLeaves(BlockPos pos, EntityPlayer player) {
        return player.field_70170_p.func_180495_p(pos).func_177230_c().isLeaves((IBlockAccess)player.field_70170_p, pos);
    }

    protected void breakBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0 && ToolHelper.shearBlock(stack, player.field_70170_p, player, pos)) {
            return;
        }
        ToolHelper.breakExtraBlock(stack, player.field_70170_p, player, pos, pos);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        boolean hit = false;
        AxisAlignedBB box = AxisAlignedBB.func_178781_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (double)(entity.field_70165_t + 1.0), (double)(entity.field_70163_u + 1.0), (double)(entity.field_70161_v + 1.0)).func_72314_b(1.0, 1.0, 1.0);
        List entities = player.field_70170_p.func_72839_b((Entity)player, box);
        for (Entity target : entities) {
            hit |= ToolHelper.attackEntity(stack, this, player, target);
        }
        return hit;
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        BlockPos start = new BlockPos((Entity)player);
        int d = 3;
        int distance = 3;
        for (int xp = start.func_177958_n() - d; xp != start.func_177958_n() + d; ++xp) {
            for (int yp = start.func_177956_o() - d; yp != start.func_177956_o() + d; ++yp) {
                for (int zp = start.func_177952_p() - d; zp != start.func_177952_p() + d; ++zp) {
                    BlockPos pos;
                    if (MathHelper.func_76130_a((int)(xp - start.func_177958_n())) + MathHelper.func_76130_a((int)(yp - start.func_177956_o())) + MathHelper.func_76130_a((int)(zp - start.func_177952_p())) >= distance || !ToolHelper.isToolEffective2(itemStack, world.func_180495_p(pos = new BlockPos(xp, yp, zp)))) continue;
                    this.breakBlock(itemStack, pos, player);
                }
            }
        }
        return itemStack;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolMaterialStats handle = (ToolMaterialStats)materials.get(0).getStats("tool");
        ToolMaterialStats head = (ToolMaterialStats)materials.get(2).getStats("tool");
        ToolMaterialStats handle2 = (ToolMaterialStats)materials.get(1).getStats("tool");
        ToolMaterialStats binding = (ToolMaterialStats)materials.get(3).getStats("tool");
        ToolNBT data = new ToolNBT(head);
        return data.get();
    }
}

