/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolBuilder;

public class ModLuck
extends ModifierTrait {
    protected static final int baseCount = 120;
    protected static final int maxLevel = 3;
    private final LuckAspect aspect;

    public ModLuck() {
        super("luck", 5931746, 3, 0);
        this.aspects.clear();
        this.aspect = new LuckAspect(this);
        this.addAspects(this.aspect, new ModifierAspect.CategoryAnyAspect(Category.HARVEST, Category.WEAPON));
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantment.field_77348_q;
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        int lvl = this.aspect.getLevel(data.current);
        this.applyEnchantments(rootCompound, lvl);
    }

    @Override
    public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
        this.rewardProgress(tool);
    }

    @Override
    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (player.field_70170_p.field_72995_K || !wasHit) {
            return;
        }
        for (int i = (int)(damageDealt / 2.0f); i > 0; --i) {
            this.rewardProgress(tool);
        }
    }

    public void rewardProgress(ItemStack tool) {
        if (random.nextFloat() > 0.02f) {
            return;
        }
        try {
            if (this.canApply(tool)) {
                this.apply(tool);
            }
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
    }

    protected void applyEnchantments(NBTTagCompound rootCompound, int lvl) {
        boolean harvest = false;
        boolean weapon = false;
        for (Category category : TagUtil.getCategories(rootCompound)) {
            if (category == Category.HARVEST) {
                harvest = true;
            }
            if (category != Category.WEAPON) continue;
            weapon = true;
        }
        if (weapon) {
            while (lvl > ToolBuilder.getEnchantmentLevel(rootCompound, Enchantment.field_77335_o)) {
                ToolBuilder.addEnchantment(rootCompound, Enchantment.field_77335_o);
            }
        }
        if (harvest) {
            while (lvl > ToolBuilder.getEnchantmentLevel(rootCompound, Enchantment.field_77346_s)) {
                ToolBuilder.addEnchantment(rootCompound, Enchantment.field_77346_s);
            }
        }
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }

    public static class LuckAspect
    extends ModifierAspect.MultiAspect {
        public LuckAspect(IModifier parent) {
            super(parent, 5931746, 3, 120, 1);
            this.freeModifierAspect = new ModifierAspect.FreeFirstModifierAspect(parent, 1);
        }

        @Override
        protected int getMaxForLevel(int level) {
            return this.countPerLevel * level * (level + 1) / 2;
        }

        public int getLevel(int current) {
            int i = 0;
            while (current >= this.getMaxForLevel(i + 1)) {
                ++i;
            }
            return i;
        }
    }
}

