/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;

public class ModSharpness
extends Modifier {
    private final int max;

    public ModSharpness(int max) {
        super("sharpness");
        this.max = max;
        this.addAspects(new ModifierAspect.MultiAspect(this, 0xFFF6F6, 5, max, 1));
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        ToolNBT toolData = TagUtil.getOriginalToolStats(rootCompound);
        float attack = toolData.attack;
        int level = data.current / this.max;
        for (int count = data.current; count > 0; --count) {
            if (attack <= 10.0f) {
                attack += 0.1f - 0.05f * attack / 10.0f;
                continue;
            }
            attack = attack <= 20.0f ? (float)((double)attack + ((double)0.05f - 0.04 * (double)attack / 20.0)) : (float)((double)attack + 0.01);
        }
        attack += (float)level * 0.25f;
        NBTTagCompound tag = TagUtil.getToolTag(rootCompound);
        attack -= toolData.attack;
        tag.func_74776_a("Attack", attack += tag.func_74760_g("Attack"));
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }
}

