/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeGrass
extends BlockGrass {
    public static PropertyEnum<DirtType> TYPE = PropertyEnum.func_177709_a((String)"type", DirtType.class);
    public static PropertyEnum<FoliageType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", FoliageType.class);

    public BlockSlimeGrass() {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_149711_c(0.65f);
        this.func_149672_a(field_149779_h);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (FoliageType grass : FoliageType.values()) {
            for (DirtType type : DirtType.values()) {
                list.add(new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_177226_a(FOLIAGE, (Comparable)((Object)grass)))));
            }
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos1 = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos2 = blockpos1;
            for (int j = 0; j < i / 16; ++j) {
                if (worldIn.func_180495_p((blockpos2 = blockpos2.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || worldIn.func_180495_p(blockpos2).func_177230_c().func_149721_r()) continue block0;
            }
            if (!worldIn.func_175623_d(blockpos2)) continue;
            IBlockState plantState = rand.nextInt(8) == 0 ? TinkerWorld.slimeGrassTall.func_176223_P().func_177226_a(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.FERN)) : TinkerWorld.slimeGrassTall.func_176223_P().func_177226_a(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.TALL_GRASS));
            if (!TinkerWorld.slimeGrassTall.func_180671_f(worldIn, blockpos2, plantState = plantState.func_177226_a(BlockTallSlimeGrass.FOLIAGE, state.func_177229_b(FOLIAGE)))) continue;
            worldIn.func_180501_a(blockpos2, plantState, 3);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().getLightOpacity((IBlockAccess)worldIn, pos.func_177984_a()) > 2) {
            worldIn.func_175656_a(pos, this.getDirtState(state));
        } else if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                Block block = worldIn.func_180495_p(pos1.func_177984_a()).func_177230_c();
                IBlockState state1 = worldIn.func_180495_p(pos1);
                if (worldIn.func_175671_l(pos1.func_177984_a()) < 4 || block.getLightOpacity((IBlockAccess)worldIn, pos1.func_177984_a()) > 2) continue;
                this.convert(worldIn, pos1, state1, (FoliageType)((Object)state.func_177229_b(FOLIAGE)));
            }
        }
    }

    public void convert(World world, BlockPos pos, IBlockState state, FoliageType foliageType) {
        IBlockState newState = this.getStateFromDirt(state);
        if (newState != null) {
            world.func_175656_a(pos, newState.func_177226_a(FOLIAGE, (Comparable)((Object)foliageType)));
        }
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FOLIAGE, BlockGrass.field_176498_a});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 14) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DirtType.values()[meta % 5])).func_177226_a(FOLIAGE, (Comparable)((Object)FoliageType.values()[meta / 5]));
    }

    public int func_176201_c(IBlockState state) {
        DirtType type = (DirtType)((Object)state.func_177229_b(TYPE));
        FoliageType grass = (FoliageType)((Object)state.func_177229_b(FOLIAGE));
        return type.ordinal() + grass.ordinal() * 5;
    }

    public int func_180651_a(IBlockState state) {
        DirtType type = (DirtType)((Object)state.func_177229_b(TYPE));
        if (type == DirtType.VANILLA) {
            return 0;
        }
        return ((BlockSlimeDirt.DirtType)((Object)this.getDirtState(state).func_177229_b(BlockSlimeDirt.TYPE))).getMeta();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getDirtState(state).func_177230_c());
    }

    public IBlockState getDirtState(IBlockState grassState) {
        DirtType type = (DirtType)((Object)grassState.func_177229_b(TYPE));
        switch (type) {
            case VANILLA: {
                return Blocks.field_150346_d.func_176223_P();
            }
            case GREEN: {
                return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.GREEN.getMeta());
            }
            case BLUE: {
                return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.BLUE.getMeta());
            }
            case PURPLE: {
                return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.PURPLE.getMeta());
            }
            case MAGMA: {
                return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.MAGMA.getMeta());
            }
        }
        return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.GREEN.getMeta());
    }

    public IBlockState getStateFromDirt(IBlockState dirtState) {
        if (dirtState.func_177230_c() == Blocks.field_150346_d && dirtState.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DirtType.VANILLA));
        }
        if (dirtState.func_177230_c() == TinkerWorld.slimeDirt) {
            if (dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.GREEN) {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DirtType.GREEN));
            }
            if (dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.BLUE) {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DirtType.BLUE));
            }
            if (dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.PURPLE) {
                return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DirtType.PURPLE));
            }
        }
        return null;
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType || plantable.getPlantType(world, pos) == EnumPlantType.Plains;
    }

    public int func_149635_D() {
        return SlimeColorizer.colorBlue;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        FoliageType foliageType = (FoliageType)((Object)state.func_177229_b(FOLIAGE));
        return SlimeColorizer.getColorStatic(foliageType);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_149635_D();
        }
        FoliageType foliageType = (FoliageType)((Object)state.func_177229_b(FOLIAGE));
        return SlimeColorizer.getColorForPos(pos, foliageType);
    }

    public static enum DirtType implements IStringSerializable
    {
        VANILLA,
        GREEN,
        BLUE,
        PURPLE,
        MAGMA;


        public String func_176610_l() {
            return this.toString();
        }
    }

    public static enum FoliageType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        BLUE,
        PURPLE,
        ORANGE;


        public static FoliageType getValFromMeta(int meta) {
            if (meta < 0 || meta >= FoliageType.values().length) {
                meta = 0;
            }
            return FoliageType.values()[meta];
        }

        public int getMeta() {
            return this.ordinal();
        }

        public String func_176610_l() {
            return this.toString();
        }
    }
}

