/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeVine
extends BlockVine {
    protected final BlockSlimeGrass.FoliageType foliage;
    protected final BlockSlimeVine nextStage;

    public BlockSlimeVine(BlockSlimeGrass.FoliageType foliage, BlockSlimeVine nextStage) {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_149672_a(field_149779_h);
        this.foliage = foliage;
        this.nextStage = nextStage;
    }

    private Boolean canAttachTo(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block.func_149686_d() && block.func_149688_o().func_76230_c();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)field_176273_b, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.func_177978_c()));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176278_M, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.func_177974_f()));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176279_N, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.func_177968_d()));
        iblockstate = iblockstate.func_177226_a((IProperty)field_176280_O, (Comparable)this.canAttachTo((IBlockAccess)worldIn, pos.func_177976_e()));
        return iblockstate;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!(this.canAttachTo((IBlockAccess)worldIn, pos.func_177978_c()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.func_177974_f()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.func_177968_d()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, pos.func_177976_e()).booleanValue() || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockVine)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        BlockPos down = pos.func_177977_b();
        while (worldIn.func_180495_p(down).func_177230_c() instanceof BlockVine) {
            worldIn.func_175689_h(down);
            down = down.func_177977_b();
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && rand.nextInt(4) == 0) {
            this.grow(worldIn, rand, pos, state);
        }
    }

    public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (this.nextStage == null) {
            return;
        }
        BlockPos below = pos.func_177977_b();
        if (worldIn.func_175623_d(below)) {
            if (!(this.canAttachTo((IBlockAccess)worldIn, below.func_177978_c()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.func_177974_f()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.func_177968_d()).booleanValue() || this.canAttachTo((IBlockAccess)worldIn, below.func_177976_e()).booleanValue())) {
                int i = 0;
                while (worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this) {
                    ++i;
                }
                if (i > 2 || rand.nextInt(2) == 0) {
                    state = this.nextStage.func_176223_P().func_177226_a((IProperty)field_176273_b, state.func_177229_b((IProperty)field_176273_b)).func_177226_a((IProperty)field_176278_M, state.func_177229_b((IProperty)field_176278_M)).func_177226_a((IProperty)field_176279_N, state.func_177229_b((IProperty)field_176279_N)).func_177226_a((IProperty)field_176280_O, state.func_177229_b((IProperty)field_176280_O));
                }
            }
            worldIn.func_175656_a(below, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        return SlimeColorizer.getColorStatic(this.foliage);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_149635_D();
        }
        return SlimeColorizer.getColorForPos(pos, this.foliage);
    }
}

