/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.awt.geom.Ellipse2D;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeVine;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class SlimeIslandGenerator
implements IWorldGenerator {
    protected int randomness = 1;
    protected SlimeLakeGenerator lakeGenGreen;
    protected SlimeLakeGenerator lakeGenBlue;
    protected SlimeLakeGenerator lakeGenPurple;
    protected SlimePlantGenerator plantGenBlue;
    protected SlimePlantGenerator plantGenPurple;
    protected SlimeTreeGenerator treeGenBlue;
    protected SlimeTreeGenerator treeGenPurple;

    public SlimeIslandGenerator() {
        IBlockState slimeGreen = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.GREEN));
        IBlockState slimeBlue = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.BLUE));
        IBlockState slimePurple = TinkerWorld.slimeBlockCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.PURPLE));
        IBlockState leaves = TinkerWorld.slimeLeaves.func_176223_P();
        this.lakeGenGreen = new SlimeLakeGenerator(Blocks.field_150355_j.func_176223_P(), slimeGreen, slimeGreen, slimeBlue);
        this.lakeGenBlue = new SlimeLakeGenerator(Blocks.field_150355_j.func_176223_P(), slimeBlue, slimeGreen, slimeBlue);
        this.lakeGenPurple = new SlimeLakeGenerator(Blocks.field_150355_j.func_176223_P(), slimePurple, slimePurple);
        this.treeGenBlue = new SlimeTreeGenerator(5, 4, slimeGreen, leaves.func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.BLUE)), TinkerWorld.slimeVineBlue3.func_176223_P());
        this.treeGenPurple = new SlimeTreeGenerator(5, 4, slimeGreen, leaves.func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.PURPLE)), TinkerWorld.slimeVinePurple3.func_176223_P());
        this.plantGenBlue = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.BLUE, false);
        this.plantGenPurple = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.PURPLE, false);
    }

    protected boolean shouldGenerateInDimension(int id) {
        return id != 1 && id != -1;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.genSlimeIslands) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!this.shouldGenerateInDimension(world.field_73011_w.func_177502_q())) {
            return;
        }
        if (random.nextInt(Config.slimeIslandsRate) > 0) {
            return;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.BLUE;
        BlockSlimeDirt.DirtType dirt = BlockSlimeDirt.DirtType.BLUE;
        SlimeLakeGenerator lakeGen = this.lakeGenBlue;
        SlimePlantGenerator plantGen = this.plantGenPurple;
        SlimeTreeGenerator treeGen = this.treeGenPurple;
        IBlockState vine = TinkerWorld.slimeVineBlue1.func_176223_P();
        int rnr = random.nextInt(10);
        if (rnr <= 1) {
            grass = BlockSlimeGrass.FoliageType.PURPLE;
            dirt = BlockSlimeDirt.DirtType.PURPLE;
            lakeGen = this.lakeGenPurple;
            treeGen = this.treeGenBlue;
            plantGen = this.plantGenBlue;
            vine = TinkerWorld.slimeVinePurple1.func_176223_P();
        } else if (rnr < 6) {
            dirt = BlockSlimeDirt.DirtType.GREEN;
            lakeGen = this.lakeGenGreen;
        }
        IBlockState dirtState = TinkerWorld.slimeDirt.func_176223_P().func_177226_a(BlockSlimeDirt.TYPE, (Comparable)((Object)dirt));
        IBlockState grassState = TinkerWorld.slimeGrass.getStateFromDirt(dirtState).func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass));
        int x = chunkX * 16 + 7 + random.nextInt(6) - 3;
        int z = chunkZ * 16 + 7 + random.nextInt(6) - 3;
        this.generateIsland(random, world, x, z, dirtState, grassState, vine, lakeGen, treeGen, plantGen);
    }

    public void generateIsland(Random random, World world, int xPos, int zPos, IBlockState dirt, IBlockState grass, IBlockState vine, SlimeLakeGenerator lakeGenerator, SlimeTreeGenerator treeGenerator, SlimePlantGenerator plantGen) {
        int i;
        BlockPos pos2;
        BlockPos pos1;
        int y;
        int z;
        int x;
        int yRange;
        int xRange = 20 + random.nextInt(13);
        int zRange = 20 + random.nextInt(13);
        int height = yRange = 11 + random.nextInt(3);
        int yBottom = world.func_175645_m(new BlockPos(xPos, 0, zPos)).func_177956_o() + 50 + random.nextInt(50);
        BlockPos center = new BlockPos(xPos, yBottom + height, zPos);
        BlockPos start = new BlockPos(xPos - xRange / 2, yBottom, zPos - zRange / 2);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, xRange, zRange);
        for (int x2 = 0; x2 <= xRange; ++x2) {
            for (int z2 = 0; z2 <= zRange; ++z2) {
                for (int y2 = 0; y2 <= yRange; ++y2) {
                    if (!ellipse.contains(x2, z2) || !world.func_175623_d(start.func_177982_a(x2, y2, z2))) continue;
                    world.func_180501_a(start.func_177982_a(x2, y2, z2), dirt, 2);
                }
            }
        }
        int erode_height = 8;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.func_177982_a(x, erode_height - y, z);
                    pos2 = start.func_177982_a(xRange - x, erode_height - y, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        if (world.func_180495_p(pos.func_177982_a(-1, 1, 0)) == dirt && world.func_180495_p(pos.func_177982_a(1, 1, 0)) == dirt && world.func_180495_p(pos.func_177982_a(0, 1, -1)) == dirt && world.func_180495_p(pos.func_177982_a(-1, 1, 1)) == dirt && random.nextInt(100) > this.randomness) continue;
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }
        erode_height = 2;
        for (x = 0; x <= xRange; ++x) {
            for (z = 0; z <= zRange; ++z) {
                for (y = 0; y <= erode_height; ++y) {
                    pos1 = start.func_177982_a(x, y + height - erode_height + 2, z);
                    pos2 = start.func_177982_a(xRange - x, y + height - erode_height + 2, zRange - z);
                    for (BlockPos pos : new BlockPos[]{pos1, pos2}) {
                        BlockPos below = pos.func_177977_b();
                        if (world.func_180495_p(below.func_177978_c()) == dirt && world.func_180495_p(below.func_177974_f()) == dirt && world.func_180495_p(below.func_177968_d()) == dirt && world.func_180495_p(below.func_177976_e()) == dirt) continue;
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }
        for (x = 0; x <= xRange; ++x) {
            block12: for (z = 0; z <= zRange; ++z) {
                BlockPos top = start.func_177982_a(x, height, z);
                for (int y3 = 0; y3 <= height; ++y3) {
                    BlockPos pos = top.func_177979_c(y3);
                    if (world.func_180495_p(pos) != dirt || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_175656_a(pos, grass);
                    continue block12;
                }
            }
        }
        if (lakeGenerator != null) {
            lakeGenerator.generateLake(random, world, center);
        }
        if (plantGen != null) {
            plantGen.generatePlants(random, world, start.func_177981_b(height + 1), start.func_177982_a(xRange, height - 3, zRange), 128);
        }
        if (treeGenerator != null) {
            for (i = 0; i < 3; ++i) {
                BlockPos pos = start.func_177982_a(random.nextInt(xRange), height, random.nextInt(zRange));
                treeGenerator.generateTree(random, world, pos);
            }
        }
        if (vine != null) {
            for (i = 0; i < 30; ++i) {
                BlockPos pos = start.func_177982_a(-1 + random.nextInt(xRange + 2), 0, -1 + random.nextInt(zRange + 2));
                this.tryPlacingVine(random, world, pos, height, vine);
            }
        }
    }

    public void tryPlacingVine(Random random, World world, BlockPos below, int limit, IBlockState vine) {
        BlockPos pos = below;
        BlockPos candidate = null;
        for (int i = 0; i < limit; ++i) {
            if ((vine.func_177230_c().func_176198_a(world, pos, EnumFacing.NORTH) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.EAST) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.SOUTH) || vine.func_177230_c().func_176198_a(world, pos, EnumFacing.WEST)) && (candidate == null || random.nextInt(10) == 0)) {
                candidate = pos;
            }
            pos = pos.func_177984_a();
        }
        if (candidate != null) {
            world.func_175656_a(candidate, vine.func_177230_c().func_180642_a(world, candidate, EnumFacing.UP, 0.0f, 0.0f, 0.0f, 0, null));
            pos = candidate;
            for (int size = random.nextInt(8); size >= 0 && world.func_180495_p(pos).func_177230_c() instanceof BlockSlimeVine; ++size) {
                ((BlockSlimeVine)world.func_180495_p(pos).func_177230_c()).grow(world, random, pos, world.func_180495_p(pos));
                pos = pos.func_177977_b();
            }
        }
    }
}

