/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.mantle.inventory.SlotWrapper;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiMultiModule
extends GuiContainer {
    private static Field NEI_Manager;
    protected List<GuiModule> modules = Lists.newArrayList();
    public int cornerX;
    public int cornerY;
    public int realWidth = -1;
    public int realHeight = -1;

    public GuiMultiModule(ContainerMultiModule container) {
        super((Container)container);
    }

    protected void addModule(GuiModule module) {
        this.modules.add(module);
    }

    public void func_73866_w_() {
        if (this.realWidth > -1) {
            this.field_146999_f = this.realWidth;
            this.field_147000_g = this.realHeight;
        }
        super.func_73866_w_();
        this.cornerX = this.field_147003_i;
        this.cornerY = this.field_147009_r;
        this.realWidth = this.field_146999_f;
        this.realHeight = this.field_147000_g;
        for (GuiModule module : this.modules) {
            this.updateSubmodule(module);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        for (GuiModule module : this.modules) {
            module.handleDrawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (GuiModule module : this.modules) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
            GlStateManager.func_179109_b((float)module.field_147003_i, (float)module.field_147009_r, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            module.handleDrawGuiContainerForegroundLayer(mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
        this.drawContainerName();
        this.drawPlayerInventoryName();
    }

    protected void drawBackground(ResourceLocation background) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.cornerX, this.cornerY, 0, 0, this.realWidth, this.realHeight);
    }

    protected void drawContainerName() {
        ContainerMultiModule multiContainer = (ContainerMultiModule)this.field_147002_h;
        IChatComponent localizedName = multiContainer.getInventoryDisplayName();
        if (localizedName != null) {
            this.field_146289_q.func_78276_b(localizedName.func_150260_c(), 8, 6, 0x404040);
        }
    }

    protected void drawPlayerInventoryName() {
        String localizedName = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(localizedName, 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        try {
            for (GuiModule module : this.modules) {
                module.func_146280_a(mc, width, height);
                if (NEI_Manager != null) {
                    NEI_Manager.set((Object)module, NEI_Manager.get((Object)this));
                }
                this.updateSubmodule(module);
            }
        }
        catch (IllegalAccessException e) {
            Mantle.logger.error((Object)e);
        }
    }

    public void func_175273_b(Minecraft mc, int width, int height) {
        super.func_175273_b(mc, width, height);
        for (GuiModule module : this.modules) {
            module.func_175273_b(mc, width, height);
            this.updateSubmodule(module);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int oldX = this.field_147003_i;
        int oldY = this.field_147009_r;
        int oldW = this.field_146999_f;
        int oldH = this.field_147000_g;
        this.field_147003_i = this.cornerX;
        this.field_147009_r = this.cornerY;
        this.field_146999_f = this.realWidth;
        this.field_147000_g = this.realHeight;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_147003_i = oldX;
        this.field_147009_r = oldY;
        this.field_146999_f = oldW;
        this.field_147000_g = oldH;
    }

    protected boolean func_146978_c(int left, int top, int right, int bottom, int pointX, int pointY) {
        return (pointX -= this.cornerX) >= left - 1 && pointX < left + right + 1 && (pointY -= this.cornerY) >= top - 1 && pointY < top + bottom + 1;
    }

    protected void updateSubmodule(GuiModule module) {
        module.updatePosition(this.cornerX, this.cornerY, this.realWidth, this.realHeight);
        if (module.field_147003_i < this.field_147003_i) {
            this.field_146999_f += this.field_147003_i - module.field_147003_i;
            this.field_147003_i = module.field_147003_i;
        }
        if (module.field_147009_r < this.field_147009_r) {
            this.field_147000_g += this.field_147009_r - module.field_147009_r;
            this.field_147009_r = module.field_147009_r;
        }
        if (module.guiRight() > this.field_147003_i + this.field_146999_f) {
            this.field_146999_f = module.guiRight() - this.field_147003_i;
        }
        if (module.guiBottom() > this.field_147009_r + this.field_147000_g) {
            this.field_147000_g = module.guiBottom() - this.field_147009_r;
        }
    }

    public void func_146977_a(Slot slotIn) {
        GuiModule module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof SlotWrapper) {
                slot = ((SlotWrapper)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return;
            }
        }
        if (slotIn instanceof SlotWrapper) {
            slotIn.field_75223_e = ((SlotWrapper)slotIn).parent.field_75223_e;
            slotIn.field_75221_f = ((SlotWrapper)slotIn).parent.field_75221_f;
        }
        super.func_146977_a(slotIn);
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        GuiModule module = this.getModuleForSlot(slotIn.field_75222_d);
        if (module != null) {
            Slot slot = slotIn;
            if (slotIn instanceof SlotWrapper) {
                slot = ((SlotWrapper)slotIn).parent;
            }
            if (!module.shouldDrawSlot(slot)) {
                return false;
            }
        }
        return super.func_146981_a(slotIn, mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) {
            return;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        GuiModule module = this.getModuleForPoint(mouseX, mouseY);
        if (module != null && module.handleMouseReleased(mouseX, mouseY, state)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    protected GuiModule getModuleForPoint(int x, int y) {
        for (GuiModule module : this.modules) {
            if (!this.func_146978_c(module.field_147003_i, module.field_147009_r, module.guiRight(), module.guiBottom(), x + this.cornerX, y + this.cornerY)) continue;
            return module;
        }
        return null;
    }

    protected GuiModule getModuleForSlot(int slotNumber) {
        return this.getModuleForContainer(this.getContainer().getSlotContainer(slotNumber));
    }

    protected GuiModule getModuleForContainer(Container container) {
        for (GuiModule module : this.modules) {
            if (module.field_147002_h != container) continue;
            return module;
        }
        return null;
    }

    protected ContainerMultiModule getContainer() {
        return (ContainerMultiModule)this.field_147002_h;
    }

    static {
        try {
            NEI_Manager = GuiContainer.class.getDeclaredField("manager");
        }
        catch (NoSuchFieldException e) {
            NEI_Manager = null;
        }
    }
}

