/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.item;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.util.LocUtils;

public class ItemMetaDynamic
extends Item {
    private static int MAX = 131071;
    protected boolean[] availabilityMask = new boolean[1];
    protected TIntObjectHashMap<String> names = new TIntObjectHashMap();

    public ItemMetaDynamic() {
        this.func_77627_a(true);
    }

    public ItemStack addMeta(int meta, String name) {
        if (meta > MAX) {
            throw new IllegalArgumentException(String.format("Metadata for %s too high, highest supported value is %d. Meta was %d", name, MAX, meta));
        }
        if (this.isValid(meta)) {
            throw new IllegalArgumentException(String.format("Metadata for %s is already taken. Meta %d is %s", name, meta, this.names.get(meta)));
        }
        while (meta >= this.availabilityMask.length) {
            this.availabilityMask = Arrays.copyOf(this.availabilityMask, this.availabilityMask.length * 2);
        }
        this.setValid(meta);
        this.names.put(meta, (Object)name);
        return new ItemStack((Item)this, 1, meta);
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (this.isValid(meta)) {
            return super.func_77667_c(stack) + "." + LocUtils.makeLocString((String)this.names.get(meta));
        }
        return super.func_77667_c(stack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int i = 0; i <= this.availabilityMask.length; ++i) {
            if (!this.isValid(i)) continue;
            subItems.add(new ItemStack(itemIn, 1, i));
        }
    }

    public int func_77647_b(int damage) {
        int meta = super.func_77647_b(damage);
        return this.isValid(meta) ? meta : 0;
    }

    protected void setValid(int meta) {
        this.availabilityMask[meta] = true;
    }

    protected boolean isValid(int meta) {
        if (meta > MAX || meta >= this.availabilityMask.length) {
            return false;
        }
        return this.availabilityMask[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModels(String prefix) {
        this.registerItemModels(prefix, this);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerItemModels(final String prefix, final Item item) {
        final String resourceId = Loader.instance().activeModContainer().getModId().toLowerCase();
        this.names.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<String>(){

            public boolean execute(int meta, String name) {
                name = String.format("%s:%s%s", resourceId, prefix, name);
                ModelBakery.addVariantName((Item)item, (String[])new String[]{name});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
                return true;
            }
        });
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (StatCollector.func_94522_b((String)(this.func_77667_c(stack) + ".tooltip"))) {
            tooltip.add(EnumChatFormatting.GRAY.toString() + LocUtils.translateRecursive(this.func_77667_c(stack) + ".tooltip", new Object[0]));
        } else if (StatCollector.func_94522_b((String)(super.func_77667_c(stack) + ".tooltip"))) {
            tooltip.add(EnumChatFormatting.GRAY.toString() + LocUtils.translateRecursive(super.func_77667_c(stack) + ".tooltip", new Object[0]));
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }
}

