/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.Mantle;

public abstract class RecipeMatch {
    public final int amountNeeded;
    public final int amountMatched;

    public RecipeMatch(int amountMatched, int amountNeeded) {
        this.amountMatched = amountMatched;
        this.amountNeeded = amountNeeded;
    }

    public abstract Match matches(ItemStack[] var1);

    public static void removeMatch(ItemStack[] stacks, Match match) {
        block0: for (ItemStack stack : match.stacks) {
            for (int i = 0; i < stacks.length; ++i) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stacks[i]) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stacks[i])) continue;
                if (stacks[i].field_77994_a < stack.field_77994_a) {
                    Mantle.logger.error("RecipeMatch has incorrect stacksize! {}", new Object[]{stacks[i].toString()});
                    continue block0;
                }
                stacks[i].field_77994_a -= stack.field_77994_a;
                if (stacks[i].field_77994_a != 0) continue block0;
                stacks[i] = null;
                continue block0;
            }
        }
    }

    public static class Match {
        public List<ItemStack> stacks;
        public int amount;

        public Match(List<ItemStack> stacks, int amount) {
            this.stacks = stacks;
            this.amount = amount;
        }
    }

    public static class Oredict
    extends RecipeMatch {
        private final List<ItemStack> oredictEntry;

        public Oredict(String oredictEntry, int amountNeeded) {
            this(oredictEntry, amountNeeded, 1);
        }

        public Oredict(String oredictEntry, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.oredictEntry = OreDictionary.getOres((String)oredictEntry);
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList<ItemStack> found = Lists.newLinkedList();
            int stillNeeded = this.amountNeeded;
            for (ItemStack ore : this.oredictEntry) {
                for (ItemStack stack : stacks) {
                    if (!OreDictionary.itemMatches((ItemStack)ore, (ItemStack)stack, (boolean)false)) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = Math.min(copy.field_77994_a, stillNeeded);
                    found.add(copy);
                    if ((stillNeeded -= copy.field_77994_a) > 0) continue;
                    return new Match(found, this.amountMatched);
                }
            }
            return null;
        }
    }

    public static class ItemCombination
    extends RecipeMatch {
        protected final ItemStack[] itemStacks;

        public ItemCombination(int amountMatched, ItemStack ... stacks) {
            super(amountMatched, 0);
            this.itemStacks = stacks;
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList<ItemStack> found = Lists.newLinkedList();
            HashSet<Integer> needed = Sets.newHashSet();
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] == null) continue;
                needed.add(i);
            }
            block1: for (ItemStack stack : stacks) {
                Iterator iter = needed.iterator();
                while (iter.hasNext()) {
                    int index = (Integer)iter.next();
                    ItemStack template = this.itemStacks[index];
                    if (!ItemStack.func_179545_c((ItemStack)template, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)template, (ItemStack)stack)) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = 1;
                    found.add(copy);
                    iter.remove();
                    continue block1;
                }
            }
            if (needed.isEmpty()) {
                return new Match(found, this.amountMatched);
            }
            return null;
        }
    }

    public static class Item
    extends RecipeMatch {
        private final ItemStack template;

        public Item(ItemStack template, int amountNeeded) {
            this(template, amountNeeded, 1);
        }

        public Item(ItemStack template, int amountNeeded, int amountMatched) {
            super(amountMatched, amountNeeded);
            this.template = template;
        }

        @Override
        public Match matches(ItemStack[] stacks) {
            LinkedList<ItemStack> found = Lists.newLinkedList();
            int stillNeeded = this.amountNeeded;
            for (ItemStack stack : stacks) {
                if (!OreDictionary.itemMatches((ItemStack)this.template, (ItemStack)stack, (boolean)false)) continue;
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = Math.min(copy.field_77994_a, stillNeeded);
                found.add(copy);
                if ((stillNeeded -= copy.field_77994_a) > 0) continue;
                return new Match(found, this.amountMatched);
            }
            return null;
        }
    }
}

