/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.blocks.world.taint;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.WeightedRandomLoot;
import thaumcraft.api.items.ItemGenericEssentiaContainer;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTC;
import thaumcraft.common.blocks.world.taint.BlockTaintFibre;
import thaumcraft.common.blocks.world.taint.ITaintBlock;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.monster.tainted.EntityTaintSwarm;
import thaumcraft.common.lib.CustomSoundType;
import thaumcraft.common.lib.utils.Utils;

public class BlockTaint
extends BlockTC
implements ITaintBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", TaintType.class);
    static Random r = new Random(System.currentTimeMillis());
    static ArrayList<WeightedRandomLoot> pdrops = null;

    public BlockTaint() {
        super(ThaumcraftMaterials.MATERIAL_TAINT);
        this.func_149711_c(10.0f);
        this.func_149752_b(100.0f);
        this.func_149672_a(new CustomSoundType("gore", 0.5f, 0.8f));
        this.func_149675_a(true);
        this.func_149647_a(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    @Override
    public void die(World world, BlockPos pos, IBlockState blockState) {
        if ((TaintType)((Object)blockState.func_177229_b((IProperty)VARIANT)) == TaintType.ROCK) {
            world.func_175656_a(pos, BlocksTC.stone.func_176203_a(13));
        } else if ((TaintType)((Object)blockState.func_177229_b((IProperty)VARIANT)) == TaintType.CRUST || (TaintType)((Object)blockState.func_177229_b((IProperty)VARIANT)) == TaintType.SOIL) {
            if (Config.soilToDirt && (TaintType)((Object)blockState.func_177229_b((IProperty)VARIANT)) == TaintType.SOIL) {
                world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
            } else {
                world.func_175656_a(pos, BlocksTC.taintDust.func_176223_P().func_177226_a((IProperty)BlockFluidBase.LEVEL, (Comparable)Integer.valueOf(3)));
            }
        } else if ((TaintType)((Object)blockState.func_177229_b((IProperty)VARIANT)) == TaintType.GEYSER) {
            world.func_175656_a(pos, BlocksTC.fluxGoo.func_176223_P());
        } else {
            world.func_175698_g(pos);
        }
        Utils.resetBiomeAt(world, pos, world.field_73012_v.nextInt(25) == 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (!world.field_72995_K) {
            if (AuraHelper.getAura(world, pos, Aspect.FLUX) < Config.AURABASE / 25 && random.nextInt(10) == 0) {
                this.die(world, pos, state);
                return;
            }
            if ((TaintType)((Object)state.func_177229_b((IProperty)VARIANT)) != TaintType.ROCK) {
                BlockTaintFibre.spreadFibres(world, pos);
            }
            if ((TaintType)((Object)state.func_177229_b((IProperty)VARIANT)) == TaintType.CRUST) {
                Random r = new Random(pos.func_177986_g());
                if (this.tryToFall(world, pos, pos)) {
                    return;
                }
                if (world.func_175623_d(pos.func_177984_a())) {
                    boolean doIt = true;
                    EnumFacing dir = EnumFacing.field_176754_o[random.nextInt(4)];
                    for (int a = 1; a < 4; ++a) {
                        if (!world.func_175623_d(pos.func_177972_a(dir).func_177979_c(a))) {
                            doIt = false;
                            break;
                        }
                        if (world.func_180495_p(pos.func_177979_c(a)).func_177230_c() == this) continue;
                        doIt = false;
                        break;
                    }
                    if (doIt && this.tryToFall(world, pos, pos.func_177972_a(dir))) {
                        return;
                    }
                }
            } else if ((TaintType)((Object)state.func_177229_b((IProperty)VARIANT)) == TaintType.GEYSER) {
                if ((double)world.field_73012_v.nextFloat() < 0.2 && world.func_72977_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 24.0) != null) {
                    EntityTaintSwarm e = new EntityTaintSwarm(world);
                    e.func_70012_b((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.25f, (float)pos.func_177952_p() + 0.5f, world.field_73012_v.nextInt(360), 0.0f);
                    world.func_72838_d((Entity)e);
                } else if (AuraHelper.getAura(world, pos, Aspect.FLUX) < Config.AURABASE / 4) {
                    AuraHelper.pollute(world, pos, 1, true);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150899_d((int)0);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br() && world.field_73012_v.nextInt(750) == 0) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Config.potionTaintPoisonID, 200, 0, false, true));
        }
    }

    public boolean func_180648_a(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        if (eventID == 1) {
            if (worldIn.field_72995_K) {
                worldIn.func_72980_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), "thaumcraft:roots", 0.1f, 0.9f + worldIn.field_73012_v.nextFloat() * 0.2f, false);
            }
            return true;
        }
        return super.func_180648_a(worldIn, pos, state, eventID, eventParam);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)TaintType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((TaintType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        return meta;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public IProperty[] getProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public String getStateName(IBlockState state, boolean fullName) {
        TaintType type = (TaintType)((Object)state.func_177229_b((IProperty)VARIANT));
        return (fullName ? "taint_" : "") + type.func_176610_l();
    }

    public static boolean canFallBelow(World world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        Block l = bs.func_177230_c();
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    if (!Utils.isWoodLog((IBlockAccess)world, pos.func_177982_a(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        if (l.isAir((IBlockAccess)world, pos)) {
            return true;
        }
        if (l == BlocksTC.fluxGoo && (Integer)bs.func_177229_b((IProperty)BlockFluidFinite.LEVEL) >= 4) {
            return false;
        }
        if (l == Blocks.field_150480_ab || l == BlocksTC.taintFibre) {
            return true;
        }
        if (l.func_176200_f(world, pos)) {
            return true;
        }
        return l.func_149688_o() == Material.field_151586_h ? true : l.func_149688_o() == Material.field_151587_i;
    }

    private boolean tryToFall(World world, BlockPos pos, BlockPos pos2) {
        if (!BlockTaintFibre.isOnlyAdjacentToTaint(world, pos)) {
            return false;
        }
        if (BlockTaint.canFallBelow(world, pos2.func_177977_b()) && pos2.func_177956_o() >= 0) {
            int b0 = 32;
            if (world.func_175707_a(pos2.func_177982_a(-b0, -b0, -b0), pos2.func_177982_a(b0, b0, b0))) {
                if (!world.field_72995_K) {
                    EntityFallingTaint entityfalling = new EntityFallingTaint(world, (float)pos2.func_177958_n() + 0.5f, (float)pos2.func_177956_o() + 0.5f, (float)pos2.func_177952_p() + 0.5f, world.func_180495_p(pos), pos);
                    world.func_72838_d((Entity)entityfalling);
                    return true;
                }
            } else {
                world.func_175698_g(pos);
                BlockPos p2 = new BlockPos((Vec3i)pos2);
                while (BlockTaint.canFallBelow(world, p2.func_177977_b()) && p2.func_177956_o() > 0) {
                    p2 = p2.func_177977_b();
                }
                if (p2.func_177956_o() > 0) {
                    world.func_175656_a(p2, BlocksTC.taintBlock.func_176223_P());
                }
            }
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int rr;
        if (state.func_177230_c() == this && (TaintType)((Object)state.func_177229_b((IProperty)VARIANT)) == TaintType.ROCK && (rr = r.nextInt(15) + fortune) > 13) {
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            ItemStack is = new ItemStack(ItemsTC.crystalEssence);
            ((ItemGenericEssentiaContainer)ItemsTC.crystalEssence).setAspects(is, new AspectList().add(Aspect.FLUX, 1));
            ret.add(is);
            return ret;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public static enum TaintType implements IStringSerializable
    {
        CRUST,
        SOIL,
        GEYSER,
        ROCK;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

