/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.EntityOwnedConstruct;
import thaumcraft.common.entities.construct.golem.IGolemAPI;
import thaumcraft.common.entities.construct.golem.ai.AIGotoBlock;
import thaumcraft.common.entities.construct.golem.ai.AIGotoEntity;
import thaumcraft.common.entities.construct.golem.tasks.Task;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;

public class EntityThaumcraftGolem
extends EntityOwnedConstruct
implements IGolemAPI {
    protected Task task = null;
    protected int taskID = Integer.MAX_VALUE;

    public EntityThaumcraftGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.9f);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIGotoEntity(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIGotoBlock(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70728_aV = 5;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public float func_70047_e() {
        return 0.7f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.task != null && this.task.isSuspended()) {
                this.task = null;
            }
            if (!MinecraftServer.func_71276_C().func_71219_W() && this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer) {
                this.func_70624_b(null);
            }
            if (this.field_70173_aa % 50 == 0) {
                this.func_70691_i(1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == 5) {
            Thaumcraft.proxy.getFX().drawGenericParticles(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 0.1, this.field_70161_v, 0.0, 0.0, 0.0, 1.0f, 1.0f, 1.0f, 0.8f, false, 176 + (this.field_70146_Z.nextBoolean() ? 0 : 3), 3, 1, 6, 0, 2.0f, 0.0f, 1);
        } else if (par1 == 6) {
            Thaumcraft.proxy.getFX().drawGenericParticles(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 0.1, this.field_70161_v, 0.0, 0.025, 0.0, 0.1f, 1.0f, 1.0f, 0.8f, false, 15, 1, 1, 10, 0, 2.0f, 0.0f, 1);
        } else if (par1 == 7) {
            Thaumcraft.proxy.getFX().drawGenericParticles(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 0.1, this.field_70161_v, 0.0, 0.05, 0.0, 1.0f, 1.0f, 1.0f, 0.8f, false, 160, 10, 1, 10, 0, 2.0f, 0.0f, 1);
        } else if (par1 == 8) {
            Thaumcraft.proxy.getFX().drawGenericParticles(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 0.1, this.field_70161_v, 0.0, 0.01, 0.0, 1.0f, 1.0f, 0.1f, 0.8f, false, 14, 1, 1, 20, 0, 2.0f, 0.0f, 1);
        } else {
            super.func_70103_a(par1);
        }
    }

    public float getGolemMoveSpeed() {
        return 1.0f;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70093_af() || player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemNameTag) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isOwner((EntityLivingBase)player)) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IWand) {
                this.func_85030_a("thaumcraft:zap", 1.0f, 1.0f);
                this.dropCarried();
                this.func_70099_a(new ItemStack(ItemsTC.golemPlacer), 0.5f);
                this.func_70106_y();
                player.func_71038_i();
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropCarried();
        }
    }

    protected void dropCarried() {
        for (ItemStack s : this.getCarrying()) {
            if (s == null) continue;
            this.func_70099_a(s, 0.25f);
        }
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
    }

    public Task getTask() {
        if (this.task == null && this.taskID != Integer.MAX_VALUE) {
            this.task = TaskHandler.getTask(this.field_70170_p.field_73011_w.func_177502_q(), this.taskID);
            this.taskID = Integer.MAX_VALUE;
        }
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    @Override
    public ItemStack holdItem(ItemStack stack) {
        if (this.func_70694_bm() == null) {
            this.func_70062_b(0, stack);
            return null;
        }
        if (this.func_70694_bm().field_77994_a < this.func_70694_bm().func_77976_d() && ItemStack.func_179545_c((ItemStack)this.func_70694_bm(), (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.func_70694_bm(), (ItemStack)stack)) {
            int d = Math.min(stack.field_77994_a, this.func_70694_bm().func_77976_d() - this.func_70694_bm().field_77994_a);
            stack.field_77994_a -= d;
            this.func_70694_bm().field_77994_a += d;
            return stack;
        }
        return null;
    }

    @Override
    public ItemStack dropItem(ItemStack stack) {
        ItemStack out = null;
        if (stack == null) {
            out = this.func_70694_bm().func_77946_l();
            this.func_70062_b(0, null);
        } else if (ItemStack.func_179545_c((ItemStack)this.func_70694_bm(), (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.func_70694_bm(), (ItemStack)stack)) {
            out = this.func_70694_bm().func_77946_l();
            out.field_77994_a = stack.field_77994_a;
            this.func_70694_bm().field_77994_a -= stack.field_77994_a;
            if (this.func_70694_bm().field_77994_a <= 0) {
                this.func_70062_b(0, null);
            }
        }
        return out;
    }

    @Override
    public boolean canCarry(ItemStack stack, boolean partial) {
        if (this.func_70694_bm() == null) {
            return true;
        }
        return this.func_70694_bm().field_77994_a < this.func_70694_bm().func_77976_d() && ItemStack.func_179545_c((ItemStack)this.func_70694_bm(), (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.func_70694_bm(), (ItemStack)stack);
    }

    @Override
    public World getGolemWorld() {
        return this.func_130014_f_();
    }

    @Override
    public boolean isCarrying(ItemStack stack) {
        if (this.func_70694_bm() != null && this.func_70694_bm().field_77994_a > 0) {
            if (stack == null) {
                return true;
            }
            if (ItemStack.func_179545_c((ItemStack)this.func_70694_bm(), (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)this.func_70694_bm(), (ItemStack)stack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack[] getCarrying() {
        return new ItemStack[]{this.func_70694_bm()};
    }
}

