/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import thaumcraft.api.golems.ISealDisplayer;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigFilter;
import thaumcraft.common.entities.construct.golem.seals.SealEmpty;
import thaumcraft.common.entities.construct.golem.seals.SealEmptyAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealFill;
import thaumcraft.common.entities.construct.golem.seals.SealFillAdvanced;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.seals.SealPickup;
import thaumcraft.common.items.ItemGenericVariants;

public class ItemSealPlacer
extends ItemGenericVariants
implements ISealDisplayer {
    public ItemSealPlacer() {
        super(new String[]{"blank", "pickup", "fill", "fill_advanced", "empty", "empty_advanced"});
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState bs = world.func_180495_p(pos);
        if (world.field_72995_K || stack.func_77952_i() == 0) {
            return false;
        }
        if (!player.func_175151_a(pos, side, stack)) {
            return false;
        }
        ISealConfigFilter seal = null;
        switch (stack.func_77952_i()) {
            case 1: {
                seal = new SealPickup();
                break;
            }
            case 2: {
                seal = new SealFill();
                break;
            }
            case 3: {
                seal = new SealFillAdvanced();
                break;
            }
            case 4: {
                seal = new SealEmpty();
                break;
            }
            case 5: {
                seal = new SealEmptyAdvanced();
            }
        }
        if (!seal.canPlaceAt(world, pos, side)) {
            return false;
        }
        SealHandler.addSealEntity(world, pos, side, seal);
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        return true;
    }
}

