/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.lang.ref.WeakReference;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.entities.construct.golem.seals.ISeal;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigArea;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.seals.SealPos;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketSealToClient;

public class SealEntity {
    WeakReference<World> world;
    SealPos sealPos;
    ISeal seal;
    private byte priority = 0;
    private BlockPos area = new BlockPos(1, 1, 1);

    public SealEntity(World world) {
        this.world = new WeakReference<World>(world);
    }

    public SealEntity(World world, SealPos sealPos, ISeal seal) {
        this.world = new WeakReference<World>(world);
        this.sealPos = sealPos;
        this.seal = seal;
        if (seal instanceof ISealConfigArea) {
            int x = sealPos.face.func_82601_c() == 0 ? 3 : 1;
            int y = sealPos.face.func_96559_d() == 0 ? 3 : 1;
            int z = sealPos.face.func_82599_e() == 0 ? 3 : 1;
            this.area = new BlockPos(x, y, z);
        }
    }

    public void tickSealEntity() {
        if (this.seal != null && this.world.get() != null) {
            this.seal.tickSeal((World)this.world.get(), this);
        }
    }

    public ISeal getSeal() {
        return this.seal;
    }

    public SealPos getSealPos() {
        return this.sealPos;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void readNBT(NBTTagCompound nbt) {
        BlockPos p = BlockPos.func_177969_a((long)nbt.func_74763_f("pos"));
        EnumFacing face = EnumFacing.field_82609_l[nbt.func_74771_c("face")];
        this.sealPos = new SealPos(p, face);
        this.setPriority(nbt.func_74771_c("priority"));
        this.seal = SealHandler.getSeal(nbt.func_74779_i("type"));
        if (this.seal != null) {
            this.seal.readCustomNBT(nbt);
            if (this.seal instanceof ISealConfigArea) {
                this.area = BlockPos.func_177969_a((long)nbt.func_74763_f("area"));
            }
        }
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("pos", this.sealPos.pos.func_177986_g());
        nbt.func_74774_a("face", (byte)this.sealPos.face.ordinal());
        nbt.func_74778_a("type", this.seal.getKey());
        nbt.func_74774_a("priority", this.getPriority());
        if (this.seal != null) {
            this.seal.writeCustomNBT(nbt);
            if (this.seal instanceof ISealConfigArea) {
                nbt.func_74772_a("area", this.area.func_177986_g());
            }
        }
        return nbt;
    }

    public void syncToClient() {
        if (this.world.get() != null && !((World)this.world.get()).field_72995_K) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new PacketSealToClient(this), ((World)this.world.get()).field_73011_w.func_177502_q());
        }
    }

    public BlockPos getArea() {
        return this.area;
    }

    public void setArea(BlockPos v) {
        this.area = v;
    }
}

