/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.IWand;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.utils.BlockUtils;

public class ItemFocusExcavation
extends ItemFocusBasic {
    static HashMap<String, Long> soundDelay = new HashMap();
    static HashMap<String, Object> beam = new HashMap();
    static HashMap<String, Float> breakcount = new HashMap();
    static HashMap<String, Integer> lastX = new HashMap();
    static HashMap<String, Integer> lastY = new HashMap();
    static HashMap<String, Integer> lastZ = new HashMap();
    public static FocusUpgradeType dowsing = new FocusUpgradeType(new ResourceLocation("thaumcraft", "textures/foci/dowsing.png"), "focus.upgrade.dowsing.name", "focus.upgrade.dowsing.text", new AspectList().add(Aspect.CRAFT, 1));

    public ItemFocusExcavation() {
        super("excavate", 409606);
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        AspectList cost = new AspectList().add(Aspect.EARTH, 1);
        if (this.isUpgradedWith(itemstack, FocusUpgradeType.silktouch)) {
            AspectList cost2 = new AspectList();
            cost2 = new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1);
            cost2.add(cost);
            cost2.add(Aspect.EARTH, this.getUpgradeLevel(itemstack, FocusUpgradeType.enlarge));
            return cost2;
        }
        if (this.isUpgradedWith(itemstack, dowsing)) {
            AspectList cost2 = new AspectList();
            cost2 = new AspectList().add(Aspect.FIRE, 1).add(Aspect.ORDER, 1);
            cost2.add(cost);
            cost2.add(Aspect.EARTH, this.getUpgradeLevel(itemstack, FocusUpgradeType.enlarge));
            return cost2;
        }
        cost.add(Aspect.EARTH, this.getUpgradeLevel(itemstack, FocusUpgradeType.enlarge));
        return cost;
    }

    @Override
    public boolean isVisCostPerTick(ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean onFocusActivation(ItemStack stack, World world, EntityLivingBase p, MovingObjectPosition movingobjectposition, int count) {
        IWand wand = (IWand)stack.func_77973_b();
        String pp = "R" + p.func_70005_c_();
        if (!p.field_70170_p.field_72995_K) {
            pp = "S" + p.func_70005_c_();
        }
        if (soundDelay.get(pp) == null) {
            soundDelay.put(pp, 0L);
        }
        if (breakcount.get(pp) == null) {
            breakcount.put(pp, Float.valueOf(0.0f));
        }
        if (lastX.get(pp) == null) {
            lastX.put(pp, 0);
        }
        if (lastY.get(pp) == null) {
            lastY.put(pp, 0);
        }
        if (lastZ.get(pp) == null) {
            lastZ.put(pp, 0);
        }
        MovingObjectPosition mop = BlockUtils.getTargetBlock(p.field_70170_p, (Entity)p, false);
        Vec3 v = p.func_70040_Z();
        double tx = p.field_70165_t + v.field_72450_a * 10.0;
        double ty = p.field_70163_u + (double)p.func_70047_e() + v.field_72448_b * 10.0;
        double tz = p.field_70161_v + v.field_72449_c * 10.0;
        int impact = 0;
        if (mop != null) {
            tx = mop.field_72307_f.field_72450_a;
            ty = mop.field_72307_f.field_72448_b;
            tz = mop.field_72307_f.field_72449_c;
            impact = 5;
            if (!p.field_70170_p.field_72995_K && soundDelay.get(pp) < System.currentTimeMillis()) {
                p.field_70170_p.func_72908_a(tx, ty, tz, "thaumcraft:rumble", 0.3f, 1.0f);
                soundDelay.put(pp, System.currentTimeMillis() + 1200L);
            }
        } else {
            soundDelay.put(pp, 0L);
        }
        if (p.field_70170_p.field_72995_K) {
            beam.put(pp, Thaumcraft.proxy.getFX().beamCont(p, tx, ty, tz, 2, 65382, false, impact > 0 ? 2.0f : 0.0f, beam.get(pp), impact));
        }
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (!(p instanceof EntityPlayer) || p.field_70170_p.canMineBlockBody((EntityPlayer)p, mop.func_178782_a()))) {
            IBlockState bs = p.field_70170_p.func_180495_p(mop.func_178782_a());
            float hardness = bs.func_177230_c().func_176195_g(p.field_70170_p, mop.func_178782_a());
            if (hardness >= 0.0f) {
                int pot = wand.getFocusPotency(stack);
                float speed = 0.05f + (float)pot * 0.1f;
                if (bs.func_177230_c().func_149688_o() == Material.field_151576_e || bs.func_177230_c().func_149688_o() == Material.field_151577_b || bs.func_177230_c().func_149688_o() == Material.field_151578_c || bs.func_177230_c().func_149688_o() == Material.field_151595_p) {
                    speed = 0.25f + (float)pot * 0.25f;
                }
                if (bs.func_177230_c() == Blocks.field_150343_Z) {
                    speed *= 3.0f;
                }
                if (lastX.get(pp).intValue() == mop.func_178782_a().func_177958_n() && lastY.get(pp).intValue() == mop.func_178782_a().func_177956_o() && lastZ.get(pp).intValue() == mop.func_178782_a().func_177952_p()) {
                    float bc = breakcount.get(pp).floatValue();
                    if (p.field_70170_p.field_72995_K && bc > 0.0f && bs.func_177230_c() != Blocks.field_150350_a) {
                        int progress = (int)(bc / hardness * 9.0f);
                        Thaumcraft.proxy.getFX().excavateFX(mop.func_178782_a(), p, progress);
                    }
                    if (p.field_70170_p.field_72995_K) {
                        if (bc >= hardness) {
                            breakcount.put(pp, Float.valueOf(0.0f));
                        } else {
                            breakcount.put(pp, Float.valueOf(bc + speed));
                        }
                    } else if (bc >= hardness) {
                        if (this.excavate(p.field_70170_p, stack, p, bs, mop.func_178782_a())) {
                            for (int a = 0; a < wand.getFocusEnlarge(stack); ++a) {
                                this.breakNeighbour(p, mop.func_178782_a(), bs, stack);
                            }
                        }
                        lastX.put(pp, Integer.MAX_VALUE);
                        lastY.put(pp, Integer.MAX_VALUE);
                        lastZ.put(pp, Integer.MAX_VALUE);
                        breakcount.put(pp, Float.valueOf(0.0f));
                    } else {
                        breakcount.put(pp, Float.valueOf(bc + speed));
                    }
                } else {
                    lastX.put(pp, mop.func_178782_a().func_177958_n());
                    lastY.put(pp, mop.func_178782_a().func_177956_o());
                    lastZ.put(pp, mop.func_178782_a().func_177952_p());
                    breakcount.put(pp, Float.valueOf(0.0f));
                }
            }
        } else {
            lastX.put(pp, Integer.MAX_VALUE);
            lastY.put(pp, Integer.MAX_VALUE);
            lastZ.put(pp, Integer.MAX_VALUE);
            breakcount.put(pp, Float.valueOf(0.0f));
        }
        return true;
    }

    private boolean excavate(World world, ItemStack stack, EntityLivingBase p, IBlockState bs, BlockPos pos) {
        int xp;
        WorldSettings.GameType gt = WorldSettings.GameType.SURVIVAL;
        if (p instanceof EntityPlayer) {
            if (((EntityPlayer)p).field_71075_bZ.field_75099_e) {
                if (((EntityPlayer)p).field_71075_bZ.field_75098_d) {
                    gt = WorldSettings.GameType.CREATIVE;
                }
            } else {
                gt = WorldSettings.GameType.ADVENTURE;
            }
        }
        if ((xp = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)gt, (EntityPlayerMP)((EntityPlayerMP)p), (BlockPos)pos)) >= 0) {
            IWand wand = (IWand)stack.func_77973_b();
            int fortune = wand.getFocusTreasure(stack);
            boolean silk = this.isUpgradedWith(wand.getFocusStack(stack), FocusUpgradeType.silktouch);
            if (p instanceof EntityPlayer && silk && bs.func_177230_c().canSilkHarvest(p.field_70170_p, pos, bs, (EntityPlayer)p)) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                ItemStack itemstack = BlockUtils.createStackedBlock(bs);
                if (itemstack != null) {
                    items.add(itemstack);
                }
                ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)bs, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)((EntityPlayer)p));
                for (ItemStack is : items) {
                    bs.func_177230_c();
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)is);
                }
            } else {
                bs.func_177230_c().func_180653_a(world, pos, bs, 1.0f, fortune);
                bs.func_177230_c().func_180637_b(world, pos, bs.func_177230_c().getExpDrop((IBlockAccess)world, pos, fortune));
            }
            world.func_175698_g(pos);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)bs));
            return true;
        }
        return false;
    }

    boolean breakNeighbour(EntityLivingBase p, BlockPos pos, IBlockState bs, ItemStack stack) {
        ArrayList<EnumFacing> faces = new ArrayList<EnumFacing>();
        faces.add(EnumFacing.DOWN);
        faces.add(EnumFacing.EAST);
        faces.add(EnumFacing.NORTH);
        faces.add(EnumFacing.SOUTH);
        faces.add(EnumFacing.UP);
        faces.add(EnumFacing.WEST);
        Collections.shuffle(faces, p.func_70681_au());
        Collections.shuffle(faces, p.field_70170_p.field_73012_v);
        for (EnumFacing dir : faces) {
            if (p.field_70170_p.func_180495_p(pos.func_177972_a(dir)) != bs || !this.excavate(p.field_70170_p, stack, p, bs, pos.func_177972_a(dir))) continue;
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer p, int count) {
        String pp = "R" + p.func_70005_c_();
        if (!p.field_70170_p.field_72995_K) {
            pp = "S" + p.func_70005_c_();
        }
        if (soundDelay.get(pp) == null) {
            soundDelay.put(pp, 0L);
        }
        if (breakcount.get(pp) == null) {
            breakcount.put(pp, Float.valueOf(0.0f));
        }
        if (lastX.get(pp) == null) {
            lastX.put(pp, 0);
        }
        if (lastY.get(pp) == null) {
            lastY.put(pp, 0);
        }
        if (lastZ.get(pp) == null) {
            lastZ.put(pp, 0);
        }
        beam.put(pp, null);
        lastX.put(pp, Integer.MAX_VALUE);
        lastY.put(pp, Integer.MAX_VALUE);
        lastZ.put(pp, Integer.MAX_VALUE);
        breakcount.put(pp, Float.valueOf(0.0f));
    }

    @Override
    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack itemstack) {
        return ItemFocusBasic.WandFocusAnimation.CHARGE;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.treasure};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.treasure, dowsing};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.enlarge};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, FocusUpgradeType.treasure, FocusUpgradeType.silktouch};
            }
        }
        return null;
    }
}

