/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.lib.aura.AuraHandler;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.CellLoc;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.devices.TileArcaneEar;

public class WorldEvents {
    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            if (event.world.field_73011_w.func_177502_q() == 0) {
                MazeHandler.loadMaze(event.world);
            }
            AuraHandler.addAuraWorld(event.world.field_73011_w.func_177502_q());
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.func_177502_q() == 0) {
            MazeHandler.saveMaze(event.world);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            return;
        }
        SealHandler.sealEntities.remove(event.world.field_73011_w.func_177502_q());
        AuraHandler.removeAuraWorld(event.world.field_73011_w.func_177502_q());
    }

    @SubscribeEvent
    public void placeBlockEvent(BlockEvent.PlaceEvent event) {
        if (this.isNearActiveBoss(event.world, event.player, event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void placeBlockEvent(BlockEvent.MultiPlaceEvent event) {
        if (this.isNearActiveBoss(event.world, event.player, event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p())) {
            event.setCanceled(true);
        }
    }

    private boolean isNearActiveBoss(World world, EntityPlayer player, int x, int y, int z) {
        ArrayList<Entity> list;
        int zz;
        int xx;
        Cell c;
        return world.field_73011_w.func_177502_q() == Config.dimensionOuterId && player != null && !player.field_71075_bZ.field_75098_d && (c = MazeHandler.getFromHashMap(new CellLoc(xx = x >> 4, zz = z >> 4))) != null && c.feature >= 2 && c.feature <= 5 && (list = EntityUtils.getEntitiesInRange(world, x, y, z, null, EntityThaumcraftBoss.class, 32.0)) != null && list.size() > 0;
    }

    @SubscribeEvent
    public void noteEvent(NoteBlockEvent.Play event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (!TileArcaneEar.noteBlockEvents.containsKey(event.world.field_73011_w.func_177502_q())) {
            TileArcaneEar.noteBlockEvents.put(event.world.field_73011_w.func_177502_q(), new ArrayList());
        }
        ArrayList<Integer[]> list = TileArcaneEar.noteBlockEvents.get(event.world.field_73011_w.func_177502_q());
        list.add(new Integer[]{event.pos.func_177958_n(), event.pos.func_177956_o(), event.pos.func_177952_p(), event.instrument.ordinal(), event.getVanillaNoteId()});
        TileArcaneEar.noteBlockEvents.put(event.world.field_73011_w.func_177502_q(), list);
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            IBlockState bs = event.world.func_180495_p(event.target.func_178782_a());
            if (bs.func_177230_c() == BlocksTC.purifyingFluid && ((BlockFluidClassic)bs.func_177230_c()).isSourceBlock((IBlockAccess)event.world, event.target.func_178782_a())) {
                event.world.func_175698_g(event.target.func_178782_a());
                event.result = new ItemStack(ItemsTC.bucketPure);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (bs.func_177230_c() == BlocksTC.liquidDeath && ((BlockFluidClassic)bs.func_177230_c()).isSourceBlock((IBlockAccess)event.world, event.target.func_178782_a())) {
                event.world.func_175698_g(event.target.func_178782_a());
                event.result = new ItemStack(ItemsTC.bucketDeath);
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
    }
}

