/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.api.wands.IWand;
import thaumcraft.common.items.tools.ItemElementalShovel;
import thaumcraft.common.items.tools.ItemThaumometer;
import thaumcraft.common.items.wands.WandManager;

public class PacketItemKeyToServer
implements IMessage,
IMessageHandler<PacketItemKeyToServer, IMessage> {
    private int dim;
    private int playerid;
    private byte key;

    public PacketItemKeyToServer() {
    }

    public PacketItemKeyToServer(EntityPlayer player, int key) {
        this.dim = player.field_70170_p.field_73011_w.func_177502_q();
        this.playerid = player.func_145782_y();
        this.key = (byte)key;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        buffer.writeByte((int)this.key);
    }

    public void fromBytes(ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.key = buffer.readByte();
    }

    public IMessage onMessage(PacketItemKeyToServer message, MessageContext ctx) {
        WorldServer world = DimensionManager.getWorld((int)message.dim);
        if (world == null) {
            return null;
        }
        Entity player = world.func_73045_a(message.playerid);
        if (player != null && player instanceof EntityPlayer && ((EntityPlayer)player).func_70694_bm() != null) {
            if (message.key == 1 && ((EntityPlayer)player).func_70694_bm().func_77973_b() instanceof IWand) {
                WandManager.toggleMisc(((EntityPlayer)player).func_70694_bm(), (World)world, (EntityPlayer)player);
            }
            if (message.key == 1 && ((EntityPlayer)player).func_70694_bm().func_77973_b() instanceof ItemElementalShovel) {
                ItemElementalShovel cfr_ignored_0 = (ItemElementalShovel)((EntityPlayer)player).func_70694_bm().func_77973_b();
                byte b = ItemElementalShovel.getOrientation(((EntityPlayer)player).func_70694_bm());
                ItemElementalShovel cfr_ignored_1 = (ItemElementalShovel)((EntityPlayer)player).func_70694_bm().func_77973_b();
                ItemElementalShovel.setOrientation(((EntityPlayer)player).func_70694_bm(), (byte)(b + 1));
            }
            if (message.key == 2 && ((EntityPlayer)player).func_70694_bm().func_77973_b() instanceof ItemThaumometer) {
                ItemThaumometer.changeVis(((EntityPlayer)player).func_70694_bm(), (World)world, (EntityPlayer)player);
            }
        }
        return null;
    }
}

