/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigArea;
import thaumcraft.common.entities.construct.golem.seals.ISealConfigProperties;
import thaumcraft.common.entities.construct.golem.seals.SealEntity;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;
import thaumcraft.common.entities.construct.golem.seals.SealPos;

public class PacketSealToClient
implements IMessage,
IMessageHandler<PacketSealToClient, IMessage> {
    BlockPos pos;
    EnumFacing face;
    String type;
    long area;
    boolean[] props = null;

    public PacketSealToClient() {
    }

    public PacketSealToClient(SealEntity se) {
        this.pos = se.getSealPos().pos;
        this.face = se.getSealPos().face;
        String string = this.type = se.getSeal() == null ? "REMOVE" : se.getSeal().getKey();
        if (se.getSeal() != null && se.getSeal() instanceof ISealConfigArea) {
            this.area = se.getArea().func_177986_g();
        }
        if (se.getSeal() != null && se.getSeal() instanceof ISealConfigProperties) {
            ISealConfigProperties cp = (ISealConfigProperties)((Object)se.getSeal());
            this.props = new boolean[cp.getProperties().length];
            for (int a = 0; a < cp.getProperties().length; ++a) {
                this.props[a] = cp.getProperties()[a].getValue();
            }
        }
    }

    public void toBytes(ByteBuf dos) {
        dos.writeLong(this.pos.func_177986_g());
        dos.writeByte(this.face.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)dos, (String)this.type);
        if (this.area != 0L) {
            dos.writeLong(this.area);
        }
        if (this.props != null) {
            for (boolean b : this.props) {
                dos.writeBoolean(b);
            }
        }
    }

    public void fromBytes(ByteBuf dat) {
        this.pos = BlockPos.func_177969_a((long)dat.readLong());
        this.face = EnumFacing.field_82609_l[dat.readByte()];
        this.type = ByteBufUtils.readUTF8String((ByteBuf)dat);
        if (!this.type.equals("REMOVE") && SealHandler.getSeal(this.type) != null) {
            if (SealHandler.getSeal(this.type) instanceof ISealConfigArea) {
                try {
                    this.area = dat.readLong();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (SealHandler.getSeal(this.type) instanceof ISealConfigProperties) {
                try {
                    ISealConfigProperties cp = (ISealConfigProperties)((Object)SealHandler.getSeal(this.type));
                    this.props = new boolean[cp.getProperties().length];
                    for (int a = 0; a < cp.getProperties().length; ++a) {
                        this.props[a] = dat.readBoolean();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public IMessage onMessage(PacketSealToClient message, MessageContext ctx) {
        if (message.type.equals("REMOVE")) {
            SealHandler.removeSealEntity(Thaumcraft.proxy.getClientWorld(), new SealPos(message.pos, message.face), true);
        } else {
            SealEntity seal = new SealEntity(Thaumcraft.proxy.getClientWorld(), new SealPos(message.pos, message.face), SealHandler.getSeal(message.type));
            if (message.area != 0L) {
                seal.setArea(BlockPos.func_177969_a((long)message.area));
            }
            if (message.props != null && seal.getSeal() instanceof ISealConfigProperties) {
                ISealConfigProperties cp = (ISealConfigProperties)((Object)seal.getSeal());
                for (int a = 0; a < message.props.length; ++a) {
                    cp.setProperty(a, message.props[a]);
                }
            }
            SealHandler.addSealEntity(Thaumcraft.proxy.getClientWorld(), seal);
        }
        return null;
    }
}

