/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.essentia;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.common.tiles.essentia.TileTube;

public class TileTubeValve
extends TileTube {
    public boolean allowFlow = true;
    boolean wasPoweredLastTick = false;
    public float rotation = 0.0f;

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.count % 5 == 0) {
            boolean gettingPower = this.gettingPower();
            if (this.wasPoweredLastTick && !gettingPower && !this.allowFlow) {
                this.allowFlow = true;
                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:squeek", 0.7f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                this.field_145850_b.func_175689_h(this.field_174879_c);
                this.func_70296_d();
            }
            if (!this.wasPoweredLastTick && gettingPower && this.allowFlow) {
                this.allowFlow = false;
                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:squeek", 0.7f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                this.field_145850_b.func_175689_h(this.field_174879_c);
                this.func_70296_d();
            }
            this.wasPoweredLastTick = gettingPower;
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.allowFlow && this.rotation < 360.0f) {
                this.rotation += 20.0f;
            } else if (this.allowFlow && this.rotation > 0.0f) {
                this.rotation -= 20.0f;
            }
        }
        super.func_73660_a();
    }

    @Override
    public boolean onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, BlockPos bp, EnumFacing side) {
        MovingObjectPosition hit = RayTracer.retraceBlock(world, player, this.field_174879_c);
        if (hit == null) {
            return false;
        }
        if (hit.subHit >= 0 && hit.subHit < 6) {
            player.field_70170_p.func_72980_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:tool", 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
            player.func_71038_i();
            this.func_70296_d();
            world.func_175689_h(this.field_174879_c);
            this.openSides[hit.subHit] = !this.openSides[hit.subHit];
            EnumFacing dir = EnumFacing.field_82609_l[hit.subHit];
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (tile != null && tile instanceof TileTube) {
                ((TileTube)tile).openSides[dir.func_176734_d().ordinal()] = this.openSides[hit.subHit];
                world.func_175689_h(this.field_174879_c.func_177972_a(dir));
                tile.func_70296_d();
            }
        }
        if (hit.subHit == 6) {
            player.field_70170_p.func_72980_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "thaumcraft:tool", 0.5f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false);
            player.func_71038_i();
            int a = this.facing.ordinal();
            this.func_70296_d();
            while (++a < 20) {
                if (this.canConnectSide(EnumFacing.field_82609_l[a % 6])) continue;
                this.facing = EnumFacing.field_82609_l[a %= 6];
                world.func_175689_h(this.field_174879_c);
                this.func_70296_d();
                break;
            }
        }
        return !world.field_72995_K;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.allowFlow = nbttagcompound.func_74767_n("flow");
        this.wasPoweredLastTick = nbttagcompound.func_74767_n("hadpower");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74757_a("flow", this.allowFlow);
        nbttagcompound.func_74757_a("hadpower", this.wasPoweredLastTick);
    }

    @Override
    public boolean isConnectable(EnumFacing face) {
        return face != this.facing && super.isConnectable(face);
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        if (this.allowFlow) {
            super.setSuction(aspect, amount);
        }
    }

    @Override
    public boolean gettingPower() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }
}

