/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;

public class TileEntityBeamReflector
extends TileEntityBeamOutput
implements ILaserNode {
    public Vector3 color = new Vector3(0.0, 1.0, 0.0);
    private EnergyStorage storage = new EnergyStorage(10.0f, 1.0f);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
    }

    public Vector3 getInputPoint() {
        float distance = 0.15f;
        Vector3 deviation = new Vector3(Math.sin(Math.toRadians(this.yaw - 180.0f)) * (double)distance, 0.0, Math.cos(Math.toRadians(this.yaw - 180.0f)) * (double)distance);
        Vector3 headVec = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.56614, (double)this.field_145849_e + 0.5);
        headVec.translate(deviation.clone().invert());
        return headVec;
    }

    public Vector3 getOutputPoint(boolean offset) {
        return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.56614, (double)this.field_145849_e + 0.5);
    }

    public double getPacketRange() {
        return 24.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public Vector3 getColor() {
        return this.color;
    }

    public boolean canConnectTo(ILaserNode laserNode) {
        return this.color.equals((Object)laserNode.getColor());
    }

    public float receiveEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.getTarget() != null) {
            if (from instanceof EnergySource.EnergySourceWireless) {
                if (((EnergySource.EnergySourceWireless)from).nodes.contains(this.getTarget())) {
                    return 0.0f;
                }
                ((EnergySource.EnergySourceWireless)from).nodes.add(this);
                return this.getTarget().receiveEnergyGC(from, amount, simulate);
            }
            return 0.0f;
        }
        return this.storage.receiveEnergyGC(amount, simulate);
    }

    public float extractEnergyGC(EnergySource from, float amount, boolean simulate) {
        return 0.0f;
    }

    public boolean nodeAvailable(EnergySource from) {
        return from instanceof EnergySource.EnergySourceWireless;
    }

    public float getEnergyStoredGC(EnergySource from) {
        return this.storage.getEnergyStoredGC();
    }

    public float getMaxEnergyStoredGC(EnergySource from) {
        return this.storage.getCapacityGC();
    }

    @Override
    public void setTarget(ILaserNode target) {
        super.setTarget(target);
    }
}

