/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityDungeonSpawnerMars;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBasicMars
extends Block
implements IDetectableResource,
IPlantableBlock,
ITileEntityProvider,
ITerraformableBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] marsBlockIcons;

    public MapColor func_149728_f(int meta) {
        switch (meta) {
            case 7: {
                return MapColor.field_151651_C;
            }
            case 5: {
                return MapColor.field_151664_l;
            }
        }
        return MapColor.field_151645_D;
    }

    public BlockBasicMars() {
        super(Material.field_151576_e);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 10) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 10) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.0), (double)((double)y + 0.0), (double)((double)z + 0.0), (double)((double)x + 0.0), (double)((double)y + 0.0), (double)((double)z + 0.0));
        }
        return super.func_149633_g(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 10 || metadata == 7) {
            return 10000.0f;
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.marsBlockIcons = new IIcon[11];
        this.marsBlockIcons[0] = par1IconRegister.func_94245_a("galacticraftmars:cobblestone");
        this.marsBlockIcons[1] = par1IconRegister.func_94245_a("galacticraftmars:decoration_desh");
        this.marsBlockIcons[2] = par1IconRegister.func_94245_a("galacticraftmars:middle");
        this.marsBlockIcons[3] = par1IconRegister.func_94245_a("galacticraftmars:brick");
        this.marsBlockIcons[4] = par1IconRegister.func_94245_a("galacticraftmars:top");
        this.marsBlockIcons[5] = par1IconRegister.func_94245_a("galacticraftmars:copper");
        this.marsBlockIcons[6] = par1IconRegister.func_94245_a("galacticraftmars:desh");
        this.marsBlockIcons[7] = par1IconRegister.func_94245_a("galacticraftmars:tin");
        this.marsBlockIcons[8] = par1IconRegister.func_94245_a("galacticraftmars:bottom");
        this.marsBlockIcons[9] = par1IconRegister.func_94245_a("galacticraftmars:iron");
        this.marsBlockIcons[10] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "blank");
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        int meta = par1World.func_72805_g(par2, par3, par4);
        if (meta == 7) {
            return 4.0f;
        }
        if (meta == 10) {
            return -1.0f;
        }
        return this.field_149782_v;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 10) {
            return new TileEntityDungeonSpawnerMars();
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (meta == 10) {
            return false;
        }
        return super.canHarvestBlock(player, meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.marsBlockIcons[5];
            }
            case 1: {
                return this.marsBlockIcons[7];
            }
            case 2: {
                return this.marsBlockIcons[6];
            }
            case 3: {
                return this.marsBlockIcons[9];
            }
            case 4: {
                return this.marsBlockIcons[0];
            }
            case 5: {
                return this.marsBlockIcons[4];
            }
            case 6: {
                return this.marsBlockIcons[2];
            }
            case 7: {
                return this.marsBlockIcons[3];
            }
            case 8: {
                return this.marsBlockIcons[1];
            }
            case 9: {
                return this.marsBlockIcons[8];
            }
            case 10: {
                return this.marsBlockIcons[10];
            }
        }
        return this.marsBlockIcons[1];
    }

    public Item func_149650_a(int meta, Random random, int par3) {
        if (meta == 2) {
            return MarsItems.marsItemBasic;
        }
        if (meta == 10) {
            return Item.func_150898_a((Block)Blocks.field_150350_a);
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        if (meta == 9) {
            return 4;
        }
        if (meta == 2) {
            return 0;
        }
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 10) {
            return 0;
        }
        if (meta == 2 && fortune >= 1) {
            return random.nextFloat() < (float)fortune * 0.29f - 0.25f ? 2 : 1;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 11; ++var4) {
            if (var4 == 10) continue;
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public boolean isValueable(int metadata) {
        switch (metadata) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(int metadata) {
        return false;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int metadata;
        if (rand.nextInt(10) == 0 && (metadata = world.func_72805_g(x, y, z)) == 7) {
            GalacticraftPlanets.spawnParticle("sludgeDrip", new Vector3((double)x + rand.nextDouble(), (double)y, (double)z + rand.nextDouble()), new Vector3(0.0, 0.0, 0.0), new Object[0]);
            if (rand.nextInt(100) == 0) {
                world.func_72980_b((double)x, (double)y, (double)z, GalacticraftCore.TEXTURE_PREFIX + "ambience.singledrip", 1.0f, 0.8f + rand.nextFloat() / 5.0f, false);
            }
        }
    }

    public boolean isTerraformable(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 5 && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return metadata < 10;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 2) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
        }
        if (metadata == 9) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
        }
        if (metadata == 10) {
            return null;
        }
        return super.getPickBlock(target, world, x, y, z);
    }
}

