/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.item.ItemElectric;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.tile.ElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemCanisterLiquidNitrogen;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemCanisterLiquidOxygen;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemCanisterMethane;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityGasLiquefier
extends ElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IFluidHandler {
    private final int tankCapacity = 2000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank gasTank = new FluidTank(this.tankCapacity * 2);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank liquidTank2 = new FluidTank(this.tankCapacity);
    public int processTimeRequired = 3;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[4];
    private int airProducts = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int gasTankType = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int fluidTankType = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int fluidTank2Type = -1;

    public TileEntityGasLiquefier() {
        this.storage.setMaxExtract(60.0f);
        this.setTierGC(2);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.airProducts == -1) {
            this.airProducts = this.getAirProducts();
        }
        if (!this.field_145850_b.field_72995_K) {
            FluidStack currentLiquid;
            FluidStack currentgas = this.gasTank.getFluid();
            this.gasTankType = currentgas == null || currentgas.amount <= 0 ? -1 : this.getIdFromName(currentgas.getFluid().getName());
            if (this.airProducts == 0 && this.gasTankType == TankGases.AIR.index) {
                this.gasTank.drain(this.gasTank.getFluidAmount(), true);
            }
            this.fluidTankType = (currentLiquid = this.liquidTank.getFluid()) == null || currentLiquid.amount == 0 ? -1 : this.getProductIdFromName(currentLiquid.getFluid().getName());
            currentLiquid = this.liquidTank2.getFluid();
            this.fluidTank2Type = currentLiquid == null || currentLiquid.amount == 0 ? -1 : this.getProductIdFromName(currentLiquid.getFluid().getName());
            ItemStack inputCanister = this.containingItems[1];
            if (inputCanister != null) {
                if (inputCanister.func_77973_b() instanceof ItemAtmosphericValve && this.airProducts > 0) {
                    if (this.gasTankType == -1 || this.gasTankType == TankGases.AIR.index && this.gasTank.getFluid().amount < this.gasTank.getCapacity()) {
                        FluidStack gcAtmosphere = FluidRegistry.getFluidStack((String)TankGases.AIR.gas, (int)4);
                        this.gasTank.fill(gcAtmosphere, true);
                        this.gasTankType = TankGases.AIR.index;
                    }
                } else {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)inputCanister);
                    if (liquid != null && liquid.amount > 0) {
                        String inputName = FluidRegistry.getFluidName((FluidStack)liquid);
                        if (this.gasTankType <= 0 && inputName.contains("methane")) {
                            if (currentgas == null || currentgas.amount + liquid.amount * 2 <= this.gasTank.getCapacity()) {
                                FluidStack gcMethane = FluidRegistry.getFluidStack((String)TankGases.METHANE.gas, (int)liquid.amount);
                                this.gasTank.fill(gcMethane, true);
                                this.gasTankType = 0;
                                if (inputCanister.func_77973_b() instanceof ItemCanisterMethane) {
                                    this.containingItems[1] = new ItemStack(AsteroidsItems.methaneCanister, 1, AsteroidsItems.methaneCanister.func_77612_l());
                                } else if (FluidContainerRegistry.isBucket((ItemStack)inputCanister) && FluidContainerRegistry.isFilledContainer((ItemStack)inputCanister)) {
                                    int amount = inputCanister.field_77994_a;
                                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                                } else {
                                    --inputCanister.field_77994_a;
                                    if (inputCanister.field_77994_a == 0) {
                                        this.containingItems[1] = null;
                                    }
                                }
                            }
                        } else if ((this.gasTankType == TankGases.OXYGEN.index || this.gasTankType == -1) && inputName.contains("oxygen")) {
                            if (currentgas == null || currentgas.amount + liquid.amount * 2 <= this.gasTank.getCapacity()) {
                                FluidStack gcgas = FluidRegistry.getFluidStack((String)TankGases.OXYGEN.gas, (int)(liquid.amount * (inputName.contains("liquid") ? 2 : 1)));
                                this.gasTank.fill(gcgas, true);
                                this.gasTankType = TankGases.OXYGEN.index;
                                if (inputCanister.func_77973_b() instanceof ItemCanisterLiquidOxygen) {
                                    this.containingItems[1] = new ItemStack(AsteroidsItems.canisterLOX, 1, AsteroidsItems.canisterLOX.func_77612_l());
                                } else if (FluidContainerRegistry.isBucket((ItemStack)inputCanister) && FluidContainerRegistry.isFilledContainer((ItemStack)inputCanister)) {
                                    int amount = inputCanister.field_77994_a;
                                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                                } else {
                                    --inputCanister.field_77994_a;
                                    if (inputCanister.field_77994_a == 0) {
                                        this.containingItems[1] = null;
                                    }
                                }
                            }
                        } else if (!(this.gasTankType != TankGases.NITROGEN.index && this.gasTankType != -1 || !inputName.contains("nitrogen") || currentgas != null && currentgas.amount + liquid.amount * 2 > this.gasTank.getCapacity())) {
                            FluidStack gcgas = FluidRegistry.getFluidStack((String)TankGases.NITROGEN.gas, (int)(liquid.amount * (inputName.contains("liquid") ? 2 : 1)));
                            this.gasTank.fill(gcgas, true);
                            this.gasTankType = TankGases.NITROGEN.index;
                            if (inputCanister.func_77973_b() instanceof ItemCanisterLiquidNitrogen) {
                                this.containingItems[1] = new ItemStack(AsteroidsItems.canisterLN2, 1, AsteroidsItems.canisterLN2.func_77612_l());
                            } else if (FluidContainerRegistry.isBucket((ItemStack)inputCanister) && FluidContainerRegistry.isFilledContainer((ItemStack)inputCanister)) {
                                int amount = inputCanister.field_77994_a;
                                this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                            } else {
                                --inputCanister.field_77994_a;
                                if (inputCanister.field_77994_a == 0) {
                                    this.containingItems[1] = null;
                                }
                            }
                        }
                    }
                }
            }
            this.checkFluidTankTransfer(2, this.liquidTank);
            this.checkFluidTankTransfer(3, this.liquidTank2);
            if (this.hasEnoughEnergyToRun && this.canProcess()) {
                if (this.tierGC == 2) {
                    int n = this.processTimeRequired = this.poweredByTierGC == 2 ? 2 : 3;
                }
                if (this.processTicks == 0) {
                    this.processTicks = this.processTimeRequired;
                } else if (--this.processTicks <= 0) {
                    this.doLiquefaction();
                    this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        if (this.containingItems[slot] != null && FluidContainerRegistry.isContainer((ItemStack)this.containingItems[slot])) {
            FluidStack liquid = tank.getFluid();
            if (liquid != null) {
                String liquidname = liquid.getFluid().getName();
                if (liquidname.equals(TankGases.METHANE.liquid)) {
                    this.tryFillContainer(tank, liquid, slot, GCItems.fuelCanister);
                } else if (liquidname.equals(TankGases.OXYGEN.liquid)) {
                    this.tryFillContainer(tank, liquid, slot, AsteroidsItems.canisterLOX);
                } else if (liquidname.equals(TankGases.NITROGEN.liquid)) {
                    this.tryFillContainer(tank, liquid, slot, AsteroidsItems.canisterLN2);
                }
            }
        } else if (this.containingItems[slot] != null && this.containingItems[slot].func_77973_b() instanceof ItemAtmosphericValve) {
            tank.drain(4, true);
        }
    }

    private void tryFillContainer(FluidTank tank, FluidStack liquid, int slot, Item canister) {
        ItemStack slotItem = this.containingItems[slot];
        boolean isCanister = slotItem.func_77973_b() instanceof ItemCanisterGeneric && slotItem.func_77960_j() > 1;
        int amountToFill = Math.min(liquid.amount, isCanister ? slotItem.func_77960_j() - 1 : 1000);
        if (isCanister) {
            this.containingItems[slot] = new ItemStack(canister, 1, slotItem.func_77960_j() - amountToFill);
            tank.drain(amountToFill, true);
        } else if (amountToFill == 1000) {
            this.containingItems[slot] = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)this.containingItems[slot]);
            if (this.containingItems[slot] == null) {
                this.containingItems[slot] = slotItem;
            } else {
                tank.drain(amountToFill, true);
            }
        }
    }

    public int getIdFromName(String gasname) {
        for (TankGases type : TankGases.values()) {
            if (!type.gas.equals(gasname)) continue;
            return type.index;
        }
        return -1;
    }

    public int getProductIdFromName(String gasname) {
        for (TankGases type : TankGases.values()) {
            if (!type.liquid.equals(gasname)) continue;
            return type.index;
        }
        return -1;
    }

    public int getScaledGasLevel(int i) {
        return this.gasTank.getFluid() != null ? this.gasTank.getFluid().amount * i / this.gasTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.liquidTank.getFluid() != null ? this.liquidTank.getFluid().amount * i / this.liquidTank.getCapacity() : 0;
    }

    public int getScaledFuelLevel2(int i) {
        return this.liquidTank2.getFluid() != null ? this.liquidTank2.getFluid().amount * i / this.liquidTank2.getCapacity() : 0;
    }

    public boolean canProcess() {
        boolean tank2HasSpace;
        if (this.gasTank.getFluid() == null || this.gasTank.getFluid().amount <= 0 || this.getDisabled(0)) {
            return false;
        }
        if (this.fluidTankType == -1 || this.fluidTank2Type == -1) {
            return true;
        }
        boolean tank1HasSpace = this.liquidTank.getFluidAmount() < this.liquidTank.getCapacity();
        boolean bl = tank2HasSpace = this.liquidTank2.getFluidAmount() < this.liquidTank2.getCapacity();
        if (this.gasTankType == TankGases.AIR.index) {
            int airProducts = this.airProducts;
            do {
                int thisProduct;
                if (((thisProduct = (airProducts & 0xF) - 1) != this.fluidTankType || !tank1HasSpace) && (thisProduct != this.fluidTank2Type || !tank2HasSpace)) continue;
                return true;
            } while ((airProducts >>= 4) > 0);
            return false;
        }
        return this.gasTankType == this.fluidTankType && tank1HasSpace || this.gasTankType == this.fluidTank2Type && tank2HasSpace;
    }

    public int getAirProducts() {
        WorldProvider WP = this.field_145850_b.field_73011_w;
        if (WP instanceof WorldProviderSpace) {
            int result = 0;
            ArrayList atmos = ((WorldProviderSpace)WP).getCelestialBody().atmosphere;
            if (atmos.size() > 0) {
                result = this.getIdFromName(((IAtmosphericGas)atmos.get(0)).name().toLowerCase()) + 1;
            }
            if (atmos.size() > 1) {
                result += 16 * (this.getIdFromName(((IAtmosphericGas)atmos.get(1)).name().toLowerCase()) + 1);
            }
            if (atmos.size() > 2) {
                result += 256 * (this.getIdFromName(((IAtmosphericGas)atmos.get(2)).name().toLowerCase()) + 1);
            }
            return result;
        }
        return 35;
    }

    public void doLiquefaction() {
        block7: {
            int gasAmount;
            block8: {
                gasAmount = this.gasTank.getFluid().amount;
                if (gasAmount == 0) {
                    return;
                }
                if (this.gasTankType != TankGases.AIR.index) break block8;
                int airProducts = this.airProducts;
                int amountToDrain = Math.min(gasAmount / 2, airProducts > 15 ? 2 : 3);
                if (amountToDrain == 0) {
                    amountToDrain = 1;
                }
                do {
                    int thisProduct;
                    if ((thisProduct = (airProducts & 0xF) - 1) >= 0) {
                        this.gasTank.drain(this.placeIntoFluidTanks(thisProduct, amountToDrain) * 2, true);
                    }
                    airProducts >>= 4;
                    if ((amountToDrain >>= 1) != 0) continue;
                    if (thisProduct != -1) break block7;
                    amountToDrain = 1;
                } while (airProducts > 0);
                break block7;
                {
                }
            }
            if (gasAmount == 1) {
                this.gasTank.drain(this.placeIntoFluidTanks(this.gasTankType, 1), true);
            } else {
                this.gasTank.drain(this.placeIntoFluidTanks(this.gasTankType, Math.min(gasAmount / 2, 3)) * 2, true);
            }
        }
    }

    private int placeIntoFluidTanks(int thisProduct, int amountToDrain) {
        int fuelSpace = this.liquidTank.getCapacity() - this.liquidTank.getFluidAmount();
        int fuelSpace2 = this.liquidTank2.getCapacity() - this.liquidTank2.getFluidAmount();
        if ((thisProduct == this.fluidTankType || this.fluidTankType == -1) && fuelSpace > 0) {
            if (amountToDrain > fuelSpace) {
                amountToDrain = fuelSpace;
            }
            this.liquidTank.fill(FluidRegistry.getFluidStack((String)TankGases.values()[thisProduct].liquid, (int)amountToDrain), true);
            this.fluidTankType = thisProduct;
        } else if ((thisProduct == this.fluidTank2Type || this.fluidTank2Type == -1) && fuelSpace2 > 0) {
            if (amountToDrain > fuelSpace2) {
                amountToDrain = fuelSpace2;
            }
            this.gasTank.drain(amountToDrain, true);
            this.liquidTank2.fill(FluidRegistry.getFluidStack((String)TankGases.values()[thisProduct].liquid, (int)amountToDrain), true);
            this.fluidTank2Type = thisProduct;
        } else {
            amountToDrain = 0;
        }
        return amountToDrain;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("gasTank")) {
            this.gasTank.readFromNBT(nbt.func_74775_l("gasTank"));
        }
        if (nbt.func_74764_b("liquidTank")) {
            this.liquidTank.readFromNBT(nbt.func_74775_l("liquidTank"));
        }
        if (nbt.func_74764_b("liquidTank2")) {
            this.liquidTank2.readFromNBT(nbt.func_74775_l("liquidTank2"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt);
        if (this.gasTank.getFluid() != null) {
            nbt.func_74782_a("gasTank", (NBTBase)this.gasTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank.getFluid() != null) {
            nbt.func_74782_a("liquidTank", (NBTBase)this.liquidTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.liquidTank2.getFluid() != null) {
            nbt.func_74782_a("liquidTank2", (NBTBase)this.liquidTank2.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.marsMachine.4.name");
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectric && ((ItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 1: {
                    FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                    return stack != null && stack.getFluid() != null && stack.getFluid().getName().toLowerCase().contains("methane");
                }
                case 2: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
                case 3: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77973_b() instanceof ItemElectric && ((ItemElectric)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f || !this.shouldPullEnergy();
                }
                case 1: {
                    return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
                }
                case 2: {
                    return FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
                }
                case 3: {
                    return FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return ItemElectric.isElectricItem((Item)itemstack.func_77973_b());
            }
            case 1: {
                FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                return stack != null && stack.getFluid() != null && this.getIdFromName(stack.getFluid().getName()) > -1;
            }
            case 2: {
                return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
            }
            case 3: {
                return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public double getPacketRange() {
        return 320.0;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank.getFluid() != null && this.liquidTank.getFluidAmount() > 0;
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            return this.liquidTank2.getFluid() != null && this.liquidTank2.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1) && resource != null && resource.isFluidEqual(this.liquidTank.getFluid())) {
            return this.liquidTank.drain(resource.amount, doDrain);
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1) && resource != null && resource.isFluidEqual(this.liquidTank2.getFluid())) {
            return this.liquidTank2.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.liquidTank.drain(maxDrain, doDrain);
        }
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == (side ^ 1)) {
            return this.liquidTank2.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)))) {
            return fluid != null && this.getIdFromName(fluid.getName()) > -1;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            int type = this.getIdFromName(FluidRegistry.getFluidName((FluidStack)resource));
            if (this.gasTankType == -1 || this.gasTankType == type && this.gasTank.getFluidAmount() < this.gasTank.getCapacity()) {
                used = this.gasTank.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.gasTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.liquidTank)};
        }
        return tankInfo;
    }

    public int func_145832_p() {
        if (this.field_145847_g == -1) {
            this.field_145847_g = 3 & this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.field_145847_g;
    }

    public static enum TankGases {
        METHANE(0, "methane", "fuel"),
        OXYGEN(1, "oxygen", "liquidoxygen"),
        NITROGEN(2, "nitrogen", "liquidnitrogen"),
        ARGON(3, "argon", "liquidargon"),
        AIR(4, "atmosphericgases", "xxyyzz");

        int index;
        String gas;
        String liquid;

        private TankGases(int id, String fluidname, String outputname) {
            this.index = id;
            this.gas = new String(fluidname);
            this.liquid = new String(outputname);
        }
    }
}

