/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.item.ItemElectric;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.entities.IBubble;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.tile.ElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTerraformBubble;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.WorldGenTerraformTree;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityTerraformer
extends ElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IBubbleProvider {
    private final int tankCapacity = 2000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    public boolean active;
    public boolean lastActive;
    public static final int WATTS_PER_TICK = 1;
    private ItemStack[] containingItems = new ItemStack[14];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public EntityTerraformBubble terraformBubble;
    private ArrayList<Vector3> terraformableBlocksList = new ArrayList();
    private ArrayList<Vector3> grassBlockList = new ArrayList();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int terraformableBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int grassBlocksListSize = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean treesDisabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean grassDisabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float size;
    public final double MAX_SIZE = 15.0;
    private int[] useCount = new int[2];

    public TileEntityTerraformer() {
        this.storage.setMaxExtract(45.0f);
    }

    public int getScaledWaterLevel(int i) {
        double fuelLevel = this.waterTank.getFluid() == null ? 0.0 : (double)this.waterTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public double getDistanceFromServer(double par1, double par3, double par5) {
        double d3 = (double)this.field_145851_c + 0.5 - par1;
        double d4 = (double)this.field_145848_d + 0.5 - par3;
        double d5 = (double)this.field_145849_e + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_145845_h() {
        int randomIndex;
        super.func_145845_h();
        if (this.terraformBubble == null && !this.field_145850_b.field_72995_K) {
            this.terraformBubble = new EntityTerraformBubble(this.field_145850_b, new Vector3((TileEntity)this), this);
            this.terraformBubble.func_70107_b(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_72838_d((Entity)this.terraformBubble);
        }
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[0] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0])) != null && liquid.getFluid().getName().equals(FluidRegistry.WATER.getName()) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(liquid, true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                    this.containingItems[0] = new ItemStack(Items.field_151133_ar, this.containingItems[0].field_77994_a);
                } else {
                    --this.containingItems[0].field_77994_a;
                    if (this.containingItems[0].field_77994_a == 0) {
                        this.containingItems[0] = null;
                    }
                }
            }
            boolean bl = this.active = (double)this.terraformBubble.getSize() == this.MAX_SIZE && this.hasEnoughEnergyToRun && this.getFirstBonemealStack() != null && this.waterTank.getFluid() != null && this.waterTank.getFluid().amount > 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.active == this.lastActive && this.ticks % 20L != 0L)) {
            this.terraformableBlocksList.clear();
            this.grassBlockList.clear();
            if (this.active) {
                int x = (int)Math.floor((float)this.field_145851_c - this.terraformBubble.getSize());
                while ((double)x < Math.ceil((float)this.field_145851_c + this.terraformBubble.getSize())) {
                    int y = (int)Math.floor((float)this.field_145848_d - this.terraformBubble.getSize());
                    while ((double)y < Math.ceil((float)this.field_145848_d + this.terraformBubble.getSize())) {
                        int z = (int)Math.floor((float)this.field_145849_e - this.terraformBubble.getSize());
                        while ((double)z < Math.ceil((float)this.field_145849_e + this.terraformBubble.getSize())) {
                            Block blockID = this.field_145850_b.func_147439_a(x, y, z);
                            Block blockIDAbove = this.field_145850_b.func_147439_a(x, y + 1, z);
                            if (blockID != Blocks.field_150350_a && this.getDistanceFromServer(x, y, z) < (double)(this.terraformBubble.getSize() * this.terraformBubble.getSize())) {
                                if (blockID instanceof ITerraformableBlock && ((ITerraformableBlock)blockID).isTerraformable(this.field_145850_b, x, y, z)) {
                                    if (!this.grassDisabled && this.getFirstSeedStack() != null) {
                                        this.terraformableBlocksList.add(new Vector3((double)x, (double)y, (double)z));
                                    }
                                } else if (blockID == Blocks.field_150349_c && blockIDAbove == Blocks.field_150350_a && !this.treesDisabled && this.getFirstSaplingStack() != null) {
                                    this.grassBlockList.add(new Vector3((double)x, (double)y, (double)z));
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.terraformableBlocksList.size() > 0 && this.ticks % 15L == 0L) {
            ArrayList<Vector3> terraformableBlocks2 = new ArrayList<Vector3>(this.terraformableBlocksList);
            randomIndex = this.field_145850_b.field_73012_v.nextInt(this.terraformableBlocksList.size());
            Vector3 vec = terraformableBlocks2.get(randomIndex);
            Block id = Blocks.field_150350_a;
            switch (this.field_145850_b.field_73012_v.nextInt(40)) {
                case 0: {
                    if (this.field_145850_b.func_147469_q(vec.intX() - 1, vec.intY(), vec.intZ()) && this.field_145850_b.func_147469_q(vec.intX() + 1, vec.intY(), vec.intZ()) && this.field_145850_b.func_147469_q(vec.intX(), vec.intY(), vec.intZ() - 1) && this.field_145850_b.func_147469_q(vec.intX(), vec.intY(), vec.intZ() + 1)) {
                        id = Blocks.field_150358_i;
                        break;
                    }
                    id = Blocks.field_150349_c;
                    break;
                }
                default: {
                    id = Blocks.field_150349_c;
                }
            }
            this.field_145850_b.func_147449_b(vec.intX(), vec.intY(), vec.intZ(), id);
            if (id == Blocks.field_150349_c) {
                this.useCount[0] = this.useCount[0] + 1;
                this.waterTank.drain(1, true);
                this.checkUsage(1);
            } else if (id == Blocks.field_150358_i) {
                this.checkUsage(2);
            }
            this.terraformableBlocksList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K && !this.treesDisabled && this.grassBlockList.size() > 0 && this.ticks % 50L == 0L) {
            ArrayList<Vector3> grassBlocks2 = new ArrayList<Vector3>(this.grassBlockList);
            randomIndex = this.field_145850_b.field_73012_v.nextInt(this.grassBlockList.size());
            Vector3 vec = grassBlocks2.get(randomIndex);
            if (new WorldGenTerraformTree(true).func_76484_a(this.field_145850_b, this.field_145850_b.field_73012_v, vec.intX(), vec.intY(), vec.intZ())) {
                this.useCount[1] = this.useCount[1] + 1;
                this.waterTank.drain(50, true);
                this.checkUsage(0);
            }
            this.grassBlockList.remove(randomIndex);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.terraformableBlocksListSize = this.terraformableBlocksList.size();
            this.grassBlocksListSize = this.grassBlockList.size();
        }
        this.size = this.hasEnoughEnergyToRun && (!this.grassDisabled || !this.treesDisabled) ? (float)Math.min((double)Math.max(0.0f, this.size + 0.1f), this.MAX_SIZE) : (float)Math.min((double)Math.max(0.0f, this.size - 0.1f), this.MAX_SIZE);
        this.lastActive = this.active;
    }

    private void checkUsage(int type) {
        ItemStack stack = null;
        if ((this.useCount[0] + this.useCount[1]) % 4 == 0 && (stack = this.getFirstBonemealStack()) != null) {
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.containingItems[this.getSelectiveStack((int)2, (int)6)] = null;
            }
        }
        switch (type) {
            case 0: {
                stack = this.getFirstSaplingStack();
                if (stack == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.getSelectiveStack((int)6, (int)10)] = null;
                break;
            }
            case 1: {
                if (this.useCount[0] % 4 != 0 || (stack = this.getFirstSeedStack()) == null) break;
                --stack.field_77994_a;
                if (stack.field_77994_a > 0) break;
                this.containingItems[this.getSelectiveStack((int)10, (int)14)] = null;
                break;
            }
            case 2: {
                this.waterTank.drain(50, true);
            }
        }
    }

    private int getSelectiveStack(int start, int end) {
        for (int i = start; i < end; ++i) {
            ItemStack stack = this.containingItems[i];
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getFirstBonemealStack() {
        int index = this.getSelectiveStack(2, 6);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSaplingStack() {
        int index = this.getSelectiveStack(6, 10);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public ItemStack getFirstSeedStack() {
        int index = this.getSelectiveStack(10, 14);
        if (index != -1) {
            return this.containingItems[index];
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        this.size = nbt.func_74760_g("BubbleSize");
        this.useCount = nbt.func_74759_k("UseCountArray");
        if (this.useCount.length == 0) {
            this.useCount = new int[2];
        }
        if (nbt.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeStandardItemsToNBT(nbt);
        nbt.func_74776_a("BubbleSize", this.size);
        nbt.func_74783_a("UseCountArray", this.useCount);
        if (this.waterTank.getFluid() != null) {
            nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"container.tileTerraformer.name");
    }

    public int[] func_94128_d(int side) {
        return new int[]{1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 1;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 1 && ItemElectric.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean shouldUseEnergy() {
        return !this.grassDisabled || !this.treesDisabled;
    }

    public double getPacketRange() {
        return 320.0;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown <= 0) {
            switch (index) {
                case 0: {
                    this.treesDisabled = !this.treesDisabled;
                    break;
                }
                case 1: {
                    this.grassDisabled = !this.grassDisabled;
                }
            }
            this.disableCooldown = 10;
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.treesDisabled;
            }
            case 1: {
                return this.grassDisabled;
            }
        }
        return false;
    }

    public IBubble getBubble() {
        return this.terraformBubble;
    }

    public void setBubbleVisible(boolean shouldRender) {
        if (this.terraformBubble == null) {
            return;
        }
        this.terraformBubble.setShouldRender(shouldRender);
    }
}

