/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.core.config.ForestryBlock;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class TileAlveary
extends TileForestry
implements IAlvearyComponent {
    protected TileInventoryAdapter inventory;
    protected final int componentBlockMeta;
    IStructureLogic structureLogic = new StructureLogicAlveary(this);
    private boolean isMaster;
    protected int masterX;
    protected int masterZ;
    protected int masterY = -99;

    public TileAlveary(int componentBlockMeta) {
        this.componentBlockMeta = componentBlockMeta;
    }

    @Override
    public void initialize() {
        int blockid = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (blockid != ForestryBlock.alveary.field_71990_ca) {
            Proxies.log.info("Updating alveary block at %s/%s/%s.", this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, ForestryBlock.alveary.field_71990_ca, this.componentBlockMeta, 2);
            this.func_70312_q();
            this.field_70331_k.func_72837_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)this);
        }
    }

    @Override
    public void func_70316_g() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.field_70331_k.func_72820_D() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public int getBlockTexture(int side, int metadata) {
        return 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        if (this.isMaster) {
            this.makeMaster();
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    protected void createInventory() {
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    @Override
    public PacketPayload getPacketPayload() {
        return null;
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == 1) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0);
        }
        this.isMaster = false;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster()) {
            TileEntity tile = this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_70329_l == this.field_70329_l && tile.field_70330_m == this.field_70330_m && tile.field_70327_n == this.field_70327_n;
    }

    @Override
    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_70329_l;
        this.masterY = tile.field_70330_m;
        this.masterZ = tile.field_70327_n;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
    }

    @Override
    public void registerBeeListener(IBeeListener event) {
    }

    @Override
    public void removeBeeListener(IBeeListener event) {
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        return res;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return Utils.isUseableByPlayer(player, this, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

