/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.proxy;

import cpw.mods.fml.client.registry.RenderingRegistry;
import forestry.apiculture.entities.EntityBee;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.render.BeeItemRenderer;
import forestry.apiculture.render.EntityBeeFX;
import forestry.apiculture.render.RenderBee;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.core.render.RenderAnalyzer;
import forestry.core.render.TextureManager;
import forestry.core.utils.Localization;
import forestry.plugins.PluginApiculture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientProxyApiculture
extends ProxyApiculture {
    @Override
    public void initializeRendering() {
        if (PluginApiculture.fancyRenderedBees) {
            RenderingRegistry.registerEntityRenderingHandler(EntityBee.class, (Render)new RenderBee());
            MinecraftForgeClient.registerItemRenderer((int)ForestryItem.beeDroneGE.field_77779_bT, (IItemRenderer)new BeeItemRenderer());
            MinecraftForgeClient.registerItemRenderer((int)ForestryItem.beePrincessGE.field_77779_bT, (IItemRenderer)new BeeItemRenderer());
            MinecraftForgeClient.registerItemRenderer((int)ForestryItem.beeQueenGE.field_77779_bT, (IItemRenderer)new BeeItemRenderer());
        }
    }

    @Override
    public void addBeeHiveFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color, int areaX, int areaY, int areaZ) {
        EntityBeeFX fx;
        if (!Config.enableParticleFX) {
            return;
        }
        Minecraft mc = Proxies.common.getClientInstance();
        if (world.field_73012_v.nextBoolean()) {
            fx = new EntityBeeFX(world, xCoord + 0.5, yCoord + 0.75, zCoord + 0.5, 0.0f, 0.0f, 0.0f, color);
        } else {
            double spawnX = xCoord + (double)world.field_73012_v.nextInt(areaX * 2) - (double)areaX;
            double spawnY = yCoord + (double)world.field_73012_v.nextInt(areaY);
            double spawnZ = zCoord + (double)world.field_73012_v.nextInt(areaZ * 2) - (double)areaZ;
            fx = new EntityBeeFX(world, spawnX, spawnY, spawnZ, 0.0f, 0.0f, 0.0f, color);
        }
        fx.func_110125_a(TextureManager.getInstance().getDefault(icon));
        mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public void addBeeSwarmFX(String icon, World world, double xCoord, double yCoord, double zCoord, int color) {
        EntityBeeFX fx;
        if (!Config.enableParticleFX) {
            return;
        }
        Minecraft mc = Proxies.common.getClientInstance();
        if (world.field_73012_v.nextBoolean()) {
            fx = new EntityBeeFX(world, xCoord, yCoord, zCoord, 0.0f, 0.0f, 0.0f, color);
        } else {
            double spawnX = xCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            double spawnY = yCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            double spawnZ = zCoord + (double)world.field_73012_v.nextInt(4) - 2.0;
            fx = new EntityBeeFX(world, spawnX, spawnY, spawnZ, 0.0f, 0.0f, 0.0f, color);
        }
        fx.func_110125_a(TextureManager.getInstance().getDefault(icon));
        mc.field_71452_i.func_78873_a((EntityFX)fx);
    }

    @Override
    public IBlockRenderer getRendererAnalyzer(String gfxBase) {
        return new RenderAnalyzer(gfxBase);
    }

    @Override
    public void addLocalizations() {
        Localization.instance.addLocalization("/lang/forestry/apiculture/");
    }
}

