/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenPlum
extends WorldGenTree {
    public WorldGenPlum(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 2 ? yCenter : 3;
        this.generateSphere(this.getCenteredAt(yCenter, 0), 2 + this.rand.nextInt(this.girth), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log6.field_71990_ca, 1);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 3);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

