/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gadgets.TileForestry;
import forestry.core.gadgets.TileNaturalistChest;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class GuiHandlerBase
implements IGuiHandler {
    public TileForestry getTileForestry(World world, int x, int y, int z) {
        try {
            return (TileForestry)world.func_72796_p(x, y, z);
        }
        catch (Exception ex) {
            Proxies.log.warning("Failed to cast a tile entity to a TileForestry at " + x + "/" + y + "/" + z);
            return null;
        }
    }

    public GuiNaturalistInventory getNaturalistChestGui(String rootUID, EntityPlayer player, World world, int x, int y, int z) {
        TileNaturalistChest tile = (TileNaturalistChest)this.getTileForestry(world, x, y, z);
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(rootUID);
        return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistInventory(speciesRoot, player.field_71071_by, tile, 5, 25), tile);
    }

    public ContainerNaturalistInventory getNaturalistChestContainer(String rootUID, EntityPlayer player, World world, int x, int y, int z) {
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(rootUID);
        speciesRoot.getBreedingTracker(world, player.field_71092_bJ).synchToPlayer(player);
        return new ContainerNaturalistInventory(speciesRoot, player.field_71071_by, (TileNaturalistChest)this.getTileForestry(world, x, y, z), 5, 25);
    }

    public ItemStack getEquippedItem(EntityPlayer player) {
        return player.func_71045_bC();
    }
}

