/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class GuiTextBox
extends GuiTextField {
    private final FontRenderer fontRenderer;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final int enabledColor = 0xE0E0E0;
    private final int disabledColor = 0x707070;
    private int lineScroll = 0;
    private int maxLines = 0;

    public GuiTextBox(FontRenderer fontRenderer, int startX, int startY, int width, int height) {
        super(fontRenderer, startX, startY, width, height);
        this.fontRenderer = fontRenderer;
        this.startX = startX;
        this.startY = startY;
        this.width = width;
        this.height = height;
    }

    private int getLineScrollOffset() {
        return 0;
    }

    public void advanceLine() {
        if (this.lineScroll < this.maxLines - 1) {
            ++this.lineScroll;
        }
    }

    public void regressLine() {
        if (this.lineScroll > 0) {
            --this.lineScroll;
        }
    }

    public boolean moreLinesAllowed() {
        return this.fontRenderer.func_78271_c(this.getCursoredText(), this.width).size() * this.fontRenderer.field_78288_b < this.height;
    }

    private String getCursoredText() {
        if (!this.func_73806_l()) {
            return this.func_73781_b();
        }
        int cursorPos = this.func_73799_h() - this.getLineScrollOffset();
        String text = this.func_73781_b();
        if (cursorPos < 0) {
            return text;
        }
        if (cursorPos >= text.length()) {
            return text + "_";
        }
        return text.substring(0, cursorPos) + "_" + text.substring(cursorPos);
    }

    private void drawScrolledSplitString(String text, int startX, int startY, int width, int textColour) {
        List list = this.fontRenderer.func_78271_c(text, width);
        this.maxLines = list.size();
        int count = 0;
        int lineY = startY;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (count < this.lineScroll) {
                ++count;
                continue;
            }
            if (lineY + this.fontRenderer.field_78288_b - startY > this.height) break;
            String line = (String)iterator.next();
            this.fontRenderer.func_78276_b(line, startX, lineY, textColour);
            lineY += this.fontRenderer.field_78288_b;
            ++count;
        }
    }

    public void func_73795_f() {
        if (!this.func_73778_q()) {
            return;
        }
        if (this.func_73783_i()) {
            GuiTextBox.func_73734_a((int)(this.startX - 1), (int)(this.startY - 1), (int)(this.startX + this.width + 1), (int)(this.startY + this.height + 1), (int)-6250336);
            GuiTextBox.func_73734_a((int)this.startX, (int)this.startY, (int)(this.startX + this.width), (int)(this.startY + this.height), (int)-16777216);
        }
        int textColour = this.func_73806_l() ? this.enabledColor : this.disabledColor;
        this.drawScrolledSplitString(this.getCursoredText(), this.startX + 2, this.startY + 2, this.width - 4, textColour);
    }
}

