/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.core.utils.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class AlloyRecipe
implements IDescriptiveRecipe {
    private final Object[] ingredients;
    private final ItemStack metal0;
    private final ItemStack metal1;
    private final ItemStack product;

    public AlloyRecipe(ItemStack metal0, ItemStack metal1, ItemStack product) {
        ItemStack ingr;
        int i;
        this.metal0 = metal0;
        this.metal1 = metal1;
        this.product = product;
        if (metal0.field_77994_a + metal1.field_77994_a > 9) {
            throw new RuntimeException("Tried to create an invalid AlloyRecipe with more than 9 ingredients.");
        }
        this.ingredients = new Object[9];
        int count = 0;
        for (i = 0; i < metal0.field_77994_a; ++i) {
            ingr = metal0.func_77946_l();
            ingr.field_77994_a = 1;
            this.ingredients[count] = ingr;
            ++count;
        }
        for (i = 0; i < metal1.field_77994_a; ++i) {
            ingr = metal1.func_77946_l();
            ingr.field_77994_a = 1;
            this.ingredients[count] = ingr;
            ++count;
        }
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        int metal0Count = 0;
        int metal1Count = 0;
        for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
            ItemStack craftStack = inventorycrafting.func_70301_a(i);
            if (craftStack == null) continue;
            if (StackUtils.isCraftingEquivalent(craftStack, this.metal0, true, false)) {
                ++metal0Count;
                continue;
            }
            if (!StackUtils.isCraftingEquivalent(craftStack, this.metal1, true, false)) continue;
            ++metal1Count;
        }
        return metal0Count == this.metal0.field_77994_a && metal1Count == this.metal1.field_77994_a;
    }

    public int func_77570_a() {
        return this.metal0.field_77994_a + this.metal1.field_77994_a;
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        return this.product.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.product;
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }

    @Override
    public Object[] getIngredients() {
        return this.ingredients;
    }
}

