/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class LiquidHelper {
    private static LinkedList myLiquids = new LinkedList();
    private static HashMap liquidMap = new HashMap();

    public static boolean isEmptyLiquidData() {
        return FluidContainerRegistry.getRegisteredFluidContainerData().length <= 0;
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)empty);
    }

    public static FluidContainerRegistry.FluidContainerData getEmptyContainer(ItemStack empty, FluidStack liquid) {
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.fluid.isFluidEqual(liquid) || !cont.emptyContainer.func_77969_a(empty)) continue;
            return cont;
        }
        return null;
    }

    public static FluidContainerRegistry.FluidContainerData getLiquidContainer(ItemStack container) {
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.filledContainer.func_77969_a(container)) continue;
            return cont;
        }
        return null;
    }

    public static FluidContainerRegistry.FluidContainerData createLiquidData(String ident, FluidStack stillLiquid, ItemStack filled, ItemStack container) {
        return new FluidContainerRegistry.FluidContainerData(new FluidStack(LiquidHelper.getOrCreateLiquid(ident), 1000), filled, container);
    }

    public static boolean isLiquid(String ident, FluidStack stack) {
        return FluidRegistry.getFluidID((String)ident) == stack.fluidID;
    }

    public static boolean exists(String ident) {
        return FluidRegistry.isFluidRegistered((String)ident);
    }

    public static Fluid getFluid(String ident) {
        Fluid fluid = FluidRegistry.getFluid((String)ident);
        return fluid;
    }

    public static Fluid getOrCreateLiquid(String ident) {
        if (!FluidRegistry.isFluidRegistered((String)ident)) {
            FluidRegistry.registerFluid((Fluid)new Fluid(ident));
            myLiquids.add(ident);
        }
        liquidMap.put(ident, FluidRegistry.getFluid((String)ident));
        return FluidRegistry.getFluid((String)ident);
    }

    public static FluidStack getLiquid(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name, (int)amount);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, null, 0);
    }

    public static void injectWaxContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, new ItemStack(ForestryItem.beeswax), 10);
    }

    public static void injectRefractoryContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, new ItemStack(ForestryItem.refractoryWax), 10);
    }

    public static void injectTinContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, ForestryItem.ingotTin, 5);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty, ItemStack remnant, int chance) {
        FluidStack contained = LiquidHelper.getLiquid(name, volume);
        if (contained == null) {
            throw new IllegalArgumentException(String.format("Attempted to inject a liquid container for the non-existent liquid '%s'.", name));
        }
        FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(contained, filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)container);
        if (RecipeManagers.squeezerManager != null && !container.filledContainer.func_77973_b().func_77634_r()) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid);
            }
        }
    }

    public static void resetLiquidIcons(IconRegister register) {
        for (String fluidString : myLiquids) {
            Fluid fluid = LiquidHelper.getFluid(fluidString);
            Icon icon = TextureManager.getInstance().registerTex(register, "liquid/" + fluid.getName());
            fluid.setIcons(icon);
        }
    }
}

