/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.utils.StringUtil;
import forestry.energy.gadgets.EngineBronze;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.GuiEngine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiEngineBronze
extends GuiEngine {
    public GuiEngineBronze(InventoryPlayer inventory, EngineBronze tile) {
        super("textures/gui/bioengine.png", (ContainerForestry)new ContainerEngineBronze(inventory, tile), tile);
        this.widgetManager.add(new LiquidTankSlot(this.widgetManager, 89, 19, 0));
        this.widgetManager.add(new LiquidTankSlot(this.widgetManager, 107, 19, 1));
        this.widgetManager.add(new BiogasSlot(this.widgetManager, 30, 47, tile));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = StringUtil.localize("tile.for.engine.2");
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int i, int j) {
        this.drawBackground();
        EngineBronze engine = (EngineBronze)this.tile;
        int temp = engine.getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.func_73729_b(this.guiLeft + 53, this.guiTop + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends Widget {
        EngineBronze engine;

        public BiogasSlot(WidgetManager manager, int xPos, int yPos, EngineBronze engine) {
            super(manager, xPos, yPos);
            this.engine = engine;
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
        }

        @Override
        public String getTooltip(EntityPlayer player) {
            return "";
        }
    }
}

