/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.EnumHumidity;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.genetics.ClimateHelper;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineRaintank
extends TileBase
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    private static final FluidStack STACK_WATER = LiquidHelper.getLiquid("water", 10);
    public TankSlot resourceTank = new TankSlot(30000);
    private InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private boolean isValidBiome = true;
    private int fillingTime;
    private int fillingTotalTime;
    private FluidContainerRegistry.FluidContainerData productPending;
    private ItemStack usedEmpty;

    public MachineRaintank() {
        this.setHints((String[])Config.hints.get("raintank"));
        if (this.field_70331_k != null) {
            BiomeGenBase biome = Utils.getBiomeAt(this.field_70331_k, this.field_70329_l, this.field_70327_n);
            if (ClimateHelper.getHumidity(biome.field_76751_G) == EnumHumidity.ARID) {
                this.setErrorState(EnumErrorCode.INVALIDBIOME);
                this.isValidBiome = false;
            }
        }
    }

    @Override
    public String func_70303_b() {
        return "factory2.1";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.RaintankGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("FillingTime", this.fillingTime);
        nbttagcompound.func_74768_a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.func_74757_a("IsValidBiome", this.isValidBiome);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
        if (this.usedEmpty != null) {
            NBTTagCompound nbttagcompoundP = new NBTTagCompound();
            this.usedEmpty.func_77955_b(nbttagcompoundP);
            nbttagcompound.func_74782_a("UsedEmpty", (NBTBase)nbttagcompoundP);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.fillingTime = nbttagcompound.func_74762_e("FillingTime");
        this.fillingTotalTime = nbttagcompound.func_74762_e("FillingTotalTime");
        this.isValidBiome = nbttagcompound.func_74767_n("IsValidBiome");
        this.resourceTank = new TankSlot(30000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("UsedEmpty")) {
            NBTTagCompound nbttagcompoundP = nbttagcompound.func_74775_l("UsedEmpty");
            this.usedEmpty = ItemStack.func_77949_a((NBTTagCompound)nbttagcompoundP);
        }
    }

    @Override
    public void updateServerSide() {
        if (!this.isValidBiome) {
            this.setErrorState(EnumErrorCode.INVALIDBIOME);
        } else if (!this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) {
            this.setErrorState(EnumErrorCode.NOSKY);
        } else if (!this.field_70331_k.func_72896_J()) {
            this.setErrorState(EnumErrorCode.NOTRAINING);
        } else {
            this.resourceTank.fill(STACK_WATER, true);
            this.setErrorState(EnumErrorCode.OK);
        }
        if (this.productPending != null) {
            if (this.tryProductAdd(this.productPending.filledContainer.func_77946_l(), true)) {
                this.productPending = null;
                return;
            }
            return;
        }
        if (this.field_70331_k.func_72820_D() % 20L != 0L) {
            return;
        }
        if (this.fillingTime > 0) {
            FluidContainerRegistry.FluidContainerData container;
            --this.fillingTime;
            if (this.fillingTime <= 0 && this.usedEmpty != null && (container = LiquidHelper.getEmptyContainer(this.usedEmpty, STACK_WATER)) != null && !this.tryProductAdd(container.filledContainer.func_77946_l(), true)) {
                this.productPending = container;
            }
            return;
        }
        if (this.tryStart(true)) {
            return;
        }
        this.usedEmpty = null;
    }

    private boolean tryStart(boolean doStart) {
        if (this.inventory.func_70301_a(0) == null) {
            return false;
        }
        if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
            return false;
        }
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getEmptyContainer(this.inventory.func_70301_a(0), STACK_WATER);
        if (container == null) {
            return false;
        }
        if (!this.tryProductAdd(container.filledContainer, false)) {
            return false;
        }
        if (this.resourceTank.getFluidAmount() < container.fluid.amount) {
            return false;
        }
        if (doStart) {
            this.resourceTank.drain(container.fluid.amount, true);
            this.func_70298_a(0, 1);
            this.fillingTotalTime = 10;
            this.fillingTime = 10;
            this.usedEmpty = container.emptyContainer;
        }
        return true;
    }

    private boolean tryProductAdd(ItemStack product, boolean doAdd) {
        if (product == null) {
            return false;
        }
        return this.inventory.tryAddStack(product, 1, 1, false, doAdd);
    }

    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 30000;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getEmptyContainer(stack, STACK_WATER);
        if (container == null) {
            return 0;
        }
        return this.inventory.addStack(stack, 0, 1, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventory.func_70301_a(1) == null) {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        if (this.inventory.func_70301_a((int)1).field_77994_a <= 0) {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        ItemStack product = new ItemStack(this.inventory.func_70301_a(1).func_77973_b(), 1);
        if (doRemove) {
            this.inventory.func_70298_a(1, 1);
        }
        return new ItemStack[]{product};
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex != 0) {
            return false;
        }
        return LiquidHelper.getEmptyContainer(itemstack, STACK_WATER) != null;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
        iCrafting.func_71112_a(container, 1, this.fillingTotalTime);
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.isFluidEqual(STACK_WATER)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.resourceTank.drain(quantityMax, doEmpty);
    }

    @Override
    public TankSlot[] getTanks() {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }
}

