/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.factory.gadgets.TileWorktable;
import forestry.factory.gui.ContainerWorktable;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GuiWorktable
extends GuiForestry {
    protected ContainerWorktable container;
    private final ItemStack bookSymbol = new ItemStack(Item.field_77760_aL);

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable.png", (ContainerForestry)new ContainerWorktable(player, tile));
        this.ySize = 218;
        this.tile = tile;
        this.container = (ContainerWorktable)this.inventorySlots;
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 20, tile, 0));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 38, tile, 1));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 146, 56, tile, 2));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 56, tile, 3));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 56, tile, 4));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 38, tile, 5));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 110, 20, tile, 6));
        this.widgetManager.add(new MemorizedSlot(this.widgetManager, 128, 20, tile, 7));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = StringUtil.localize("tile.for." + this.tile.func_70303_b());
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        this.drawBackground();
        this.drawItemStack(this.bookSymbol, this.guiLeft + 128, this.guiTop + 38);
    }

    private static class MemorizedSlot
    extends Widget {
        TileWorktable tile;
        int slot;

        public MemorizedSlot(WidgetManager manager, int xPos, int yPos, TileWorktable tile, int slot) {
            super(manager, xPos, yPos);
            this.tile = tile;
            this.slot = slot;
        }

        private ItemStack getOutputStack() {
            return this.tile.getMemory().getRecipeOutput(this.slot);
        }

        @Override
        public void draw(int startX, int startY) {
            ItemStack output = this.getOutputStack();
            if (output == null) {
                return;
            }
            RenderHelper.func_74519_b();
            this.manager.gui.drawItemStack(output, startX + this.xPos, startY + this.yPos);
            if (this.tile.getMemory().isLocked(this.slot)) {
                this.manager.gui.setZLevel(150.0f);
                Proxies.common.bindTexture(SpriteSheet.ITEMS);
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, TextureManager.getInstance().getDefault("slots/locked"), 16, 16);
                this.manager.gui.setZLevel(0.0f);
            }
        }

        @Override
        protected String getTooltip(EntityPlayer player) {
            ItemStack output = this.getOutputStack();
            return output != null ? output.func_82833_r() : null;
        }

        @Override
        public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            ((GuiWorktable)this.manager.gui).container.sendRecipeClick(mouseButton, this.slot);
        }
    }
}

