/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public abstract class TileFarm
extends TileForestry
implements IFarmComponent {
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_REVERSE = 1;
    public static final int TYPE_TOP = 2;
    public static final int TYPE_BAND = 3;
    public static final int TYPE_GEARS = 4;
    public static final int TYPE_HATCH = 5;
    public static final int TYPE_VALVE = 6;
    public static final int TYPE_CONTROL = 7;
    EnumFarmBlock farmBlock = EnumFarmBlock.BRICK_STONE;
    protected int fixedType = -1;
    protected TileInventoryAdapter inventory;
    IStructureLogic structureLogic = Farmables.farmInterface.createFarmStructureLogic(this);
    private boolean isMaster;
    private int masterX;
    private int masterZ;
    private int masterY = -99;

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.field_70331_k, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        this.farmBlock = EnumFarmBlock.getFromCompound(nbttagcompound);
        if (this.isMaster) {
            this.makeMaster();
        }
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.farmBlock.saveToCompound(nbttagcompound);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void func_70316_g() {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.field_70331_k.func_72820_D() % 200L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
    }

    protected void updateClientSide() {
    }

    public void setFarmBlock(EnumFarmBlock block) {
        this.farmBlock = block;
        this.sendNetworkUpdate();
    }

    public EnumFarmBlock getFarmBlock() {
        return this.farmBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(int side, int meta) {
        return null;
    }

    protected abstract void createInventory();

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 1);
        payload.shortPayload[0] = (short)this.farmBlock.ordinal();
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.farmBlock = EnumFarmBlock.values()[payload.shortPayload[0]];
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.setCentralTE(null);
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        if (this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) == 1) {
            this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0);
        }
        this.isMaster = false;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster) {
            TileEntity tile = this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.field_70331_k.func_72796_p(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_70329_l == this.field_70329_l && tile.field_70330_m == this.field_70330_m && tile.field_70327_n == this.field_70327_n;
    }

    @Override
    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_70329_l;
        this.masterY = tile.field_70330_m;
        this.masterZ = tile.field_70327_n;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public void registerListener(IFarmListener listener) {
    }

    @Override
    public void removeListener(IFarmListener listener) {
    }

    @Override
    public String func_70303_b() {
        return "Farm";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return Utils.isUseableByPlayer(player, this, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public static enum EnumFarmBlock {
        BRICK_STONE(new ItemStack(Block.field_72007_bm, 1, 0)),
        BRICK_MOSSY(new ItemStack(Block.field_72007_bm, 1, 1)),
        BRICK_CRACKED(new ItemStack(Block.field_72007_bm, 1, 2)),
        BRICK(new ItemStack(Block.field_72081_al)),
        SANDSTONE_SMOOTH(new ItemStack(Block.field_71957_Q, 1, 2)),
        SANDSTONE_CHISELED(new ItemStack(Block.field_71957_Q, 1, 1)),
        BRICK_NETHER(new ItemStack(Block.field_72033_bA)),
        BRICK_CHISELED(new ItemStack(Block.field_72007_bm, 1, 3)),
        QUARTZ(new ItemStack(Block.field_94339_ct, 1, 0)),
        QUARTZ_CHISELED(new ItemStack(Block.field_94339_ct, 1, 1)),
        QUARTZ_LINES(new ItemStack(Block.field_94339_ct, 1, 2));

        public final ItemStack base;
        @SideOnly(value=Side.CLIENT)
        private static Icon[] icons;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumFarmBlock() {
            void base;
            this.base = base;
        }

        @SideOnly(value=Side.CLIENT)
        public static void registerIcons(IconRegister register) {
            icons = new Icon[8];
            EnumFarmBlock.icons[0] = TextureManager.getInstance().registerTex(register, "farm/plain");
            EnumFarmBlock.icons[1] = TextureManager.getInstance().registerTex(register, "farm/reverse");
            EnumFarmBlock.icons[2] = TextureManager.getInstance().registerTex(register, "farm/top");
            EnumFarmBlock.icons[3] = TextureManager.getInstance().registerTex(register, "farm/band");
            EnumFarmBlock.icons[4] = TextureManager.getInstance().registerTex(register, "farm/gears");
            EnumFarmBlock.icons[5] = TextureManager.getInstance().registerTex(register, "farm/hatch");
            EnumFarmBlock.icons[6] = TextureManager.getInstance().registerTex(register, "farm/valve");
            EnumFarmBlock.icons[7] = TextureManager.getInstance().registerTex(register, "farm/control");
        }

        @SideOnly(value=Side.CLIENT)
        public Icon getIcon(int type) {
            return icons[type];
        }

        public void saveToCompound(NBTTagCompound compound) {
            compound.func_74768_a("FarmBlock", this.ordinal());
        }

        public String getName() {
            return Item.field_77698_e[this.base.field_77993_c].func_77628_j(this.base);
        }

        public ItemStack getCraftingIngredient() {
            return this.base;
        }

        public static EnumFarmBlock getFromCompound(NBTTagCompound compound) {
            int farmBlockOrdinal;
            if (compound != null && (farmBlockOrdinal = compound.func_74762_e("FarmBlock")) < EnumFarmBlock.values().length) {
                return EnumFarmBlock.values()[farmBlockOrdinal];
            }
            return BRICK_STONE;
        }
    }
}

