/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FarmableGenericCrop
implements IFarmable {
    private ItemStack seed;
    private int blockid;
    private int mature;

    public FarmableGenericCrop(ItemStack seed, int blockid, int mature) {
        this.seed = seed;
        this.blockid = blockid;
        this.mature = mature;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_72799_c(x, y, z)) {
            return false;
        }
        return world.func_72798_a(x, y, z) == this.blockid;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) != this.blockid) {
            return null;
        }
        if (world.func_72805_g(x, y, z) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.blockid, this.mature, new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.seed.field_77993_c != itemstack.field_77993_c) {
            return false;
        }
        if (this.seed.func_77960_j() >= 0) {
            return this.seed.func_77960_j() == itemstack.func_77960_j();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(Utils.getForestryPlayer(world, x, y, z), world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

