/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.core.genetics.AlleleSpecies;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;

public class AlleleButterflySpecies
extends AlleleSpecies
implements IAlleleButterflySpecies {
    private IButterflyRoot root;
    private String texture;
    private int serumColour;
    private float rarity = 0.1f;
    private float flightDistance = 5.0f;
    private boolean isActualNocturnal = false;
    private EnumSet spawnBiomes = EnumSet.noneOf(BiomeDictionary.Type.class);
    private Map butterflyLoot = new HashMap();
    private Map caterpillarLoot = new HashMap();

    public AlleleButterflySpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int serumColour) {
        super(uid, isDominant, name, branch, binomial);
        this.root = (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
        this.serumColour = serumColour;
        this.texture = "textures/entity/butterflies/" + uid + ".png";
    }

    @Override
    public IButterflyRoot getRoot() {
        return this.root;
    }

    public AlleleButterflySpecies setRarity(float rarity) {
        this.rarity = rarity;
        return this;
    }

    public AlleleButterflySpecies setFlightDistance(float flightDistance) {
        this.flightDistance = flightDistance;
        return this;
    }

    public AlleleButterflySpecies setNocturnal(boolean isActualNocturnal) {
        this.isActualNocturnal = isActualNocturnal;
        return this;
    }

    public AlleleButterflySpecies addSpawnBiomes(EnumSet biomeTags) {
        this.spawnBiomes.addAll(biomeTags);
        return this;
    }

    public AlleleButterflySpecies addSpawnBiome(BiomeDictionary.Type biomeTag) {
        this.spawnBiomes.add(biomeTag);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return null;
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public EnumSet getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public boolean strictSpawnMatch() {
        return false;
    }

    @Override
    public int getComplexity() {
        return (int)((double)(1.35f / this.rarity) * 1.5);
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (itemstack.field_77993_c == Item.field_77729_bt.field_77779_bT) {
            return 0.9f;
        }
        for (ItemStack stack : this.butterflyLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack stack : this.caterpillarLoot.keySet()) {
            if (!stack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        return super.getResearchSuitability(itemstack);
    }

    @Override
    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        return new ItemStack[]{this.getRoot().getMemberStack(individual.copy(), EnumFlutterType.SERUM.ordinal())};
    }

    @Override
    public boolean isSecret() {
        return this.rarity < 0.8f;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isNocturnal() {
        return this.isActualNocturnal;
    }

    @Override
    public Map getButterflyLoot() {
        return this.butterflyLoot;
    }

    @Override
    public Map getCaterpillarLoot() {
        return this.caterpillarLoot;
    }

    @Override
    public int getIconColour(int renderPass) {
        if (renderPass > 0) {
            return 0xFFFFFF;
        }
        return this.serumColour;
    }
}

